/*
* Copyright (c) 2002 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0""
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:           
*       Provides global tables.
*
*/











#ifndef __AKN_FEP_VIET_TABLES_H__
#define __AKN_FEP_VIET_TABLES_H__

// Vietnamese tone tables

const TInt KNumberOfToneMarks = 5; // This equals the tone marks5 + mother vowel1

const TText VietVowelList[] = {
    0x0041, 0x0061, 0x0102, 0x0103, 0x00c2, 
    0x00e2, 0x0045, 0x0065, 0x00ca, 0x00ea,
    0x0049, 0x0069, 0x004f, 0x006f, 0x00d4,
    0x00f4, 0x01a0, 0x01a1, 0x0055, 0x0075,
    0x01af, 0x01b0, 0x0059, 0x0079
    };

const TText VietToneMatrix[][KNumberOfToneMarks] = 
    {
    0x0301, 0x0300, 0x0309, 0x0303, 0x0323, // Tone Marks
    0x00c1, 0x00c0, 0x1ea2, 0x00c3, 0x1ea0,
    0x00e1, 0x00e0, 0x1ea3, 0x00e3, 0x1ea1,
    0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 0x1eb6,
    0x1eaf, 0x1eb1, 0x1eb3, 0x1eb5, 0x1eb7,
    0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac,
    0x1ea5, 0x1ea7, 0x1ea9, 0x1eab, 0x1ead,
    0x00c9, 0x00c8, 0x1eba, 0x1ebc, 0x1eb8,
    0x00e9, 0x00e8, 0x1ebb, 0x1ebd, 0x1eb9,
    0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 0x1ec6,
    0x1ebf, 0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7,
    0x00cd, 0x00cc, 0x1ec8, 0x0128, 0x1eca,
    0x00ed, 0x00ec, 0x1ec9, 0x0129, 0x1ecb,
    0x00d3, 0x00d2, 0x1ece, 0x00d5, 0x1ecc,
    0x00f3, 0x00f2, 0x1ecf, 0x00f5, 0x1ecd,
    0x1ed0, 0x1ed2, 0x1ed4, 0x1ed6, 0x1ed8,
    0x1ed1, 0x1ed3, 0x1ed5, 0x1ed7, 0x1ed9,
    0x1eda, 0x1edc, 0x1ede, 0x1ee0, 0x1ee2,
    0x1edb, 0x1edd, 0x1edf, 0x1ee1, 0x1ee3,
    0x00da, 0x00d9, 0x1ee6, 0x0168, 0x1ee4,
    0x00fa, 0x00f9, 0x1ee7, 0x0169, 0x1ee5,
    0x1ee8, 0x1eea, 0x1eec, 0x1eee, 0x1ef0,
    0x1ee9, 0x1eeb, 0x1eed, 0x1eef, 0x1ef1,
    0x00dd, 0x1ef2, 0x1ef6, 0x1ef8, 0x1ef4,
    0x00fd, 0x1ef3, 0x1ef7, 0x1ef9, 0x1ef5
    };

#endif // __AKN_FEP_VIET_TABLES_H__

// End of file
