#
# key_codes.py
#
# S60 Python key code constants
# Recommended usage: from key_codes import *
#
# Copyright (c) 2005 - 2009 Nokia Corporation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

EKeyNull = 0x0000
EKeyBell = 0x0007
EKeyBackspace = 0x0008
EKeyTab = 0x0009
EKeyLineFeed = 0x000a
EKeyVerticalTab = 0x000b
EKeyFormFeed = 0x000c
EKeyEnter = 0x000d
EKeyEscape = 0x001b
EKeySpace = 0x0020
EKeyDelete = 0x007f
EKeyPrintScreen = 0xf800
EKeyPause = 0xf801
EKeyHome = 0xf802
EKeyEnd = 0xf803
EKeyPageUp = 0xf804
EKeyPageDown = 0xf805
EKeyInsert = 0xf806
EKeyLeftArrow = 0xf807
EKeyRightArrow = 0xf808
EKeyUpArrow = 0xf809
EKeyDownArrow = 0xf80a
EKeyLeftShift = 0xf80b
EKeyRightShift = 0xf80c
EKeyLeftAlt = 0xf80d
EKeyRightAlt = 0xf80e
EKeyLeftCtrl = 0xf80f
EKeyRightCtrl = 0xf810
EKeyLeftFunc = 0xf811
EKeyRightFunc = 0xf812
EKeyCapsLock = 0xf813
EKeyNumLock = 0xf814
EKeyScrollLock = 0xf815
EKeyF1 = 0xf816
EKeyF2 = 0xf817
EKeyF3 = 0xf818
EKeyF4 = 0xf819
EKeyF5 = 0xf81a
EKeyF6 = 0xf81b
EKeyF7 = 0xf81c
EKeyF8 = 0xf81d
EKeyF9 = 0xf81e
EKeyF10 = 0xf81f
EKeyF11 = 0xf820
EKeyF12 = 0xf821
EKeyF13 = 0xf822
EKeyF14 = 0xf823
EKeyF15 = 0xf824
EKeyF16 = 0xf825
EKeyF17 = 0xf826
EKeyF18 = 0xf827
EKeyF19 = 0xf828
EKeyF20 = 0xf829
EKeyF21 = 0xf82a
EKeyF22 = 0xf82b
EKeyF23 = 0xf82c
EKeyF24 = 0xf82d
EKeyOff = 0xf82e
EKeyIncContrast = 0xf82f
EKeyDecContrast = 0xf830
EKeyBacklightOn = 0xf831
EKeyBacklightOff = 0xf832
EKeyBacklightToggle = 0xf833
EKeySliderDown = 0xf834
EKeySliderUp = 0xf835
EKeyMenu = 0xf836
EKeyDictaphonePlay = 0xf837
EKeyDictaphoneStop = 0xf838
EKeyDictaphoneRecord = 0xf839
EKeyHelp = 0xf83a
EKeyDial = 0xf83b
EKeyScreenDimension0 = 0xf83c
EKeyScreenDimension1 = 0xf83d
EKeyScreenDimension2 = 0xf83e
EKeyScreenDimension3 = 0xf83f
EKeyIncVolume = 0xf840
EKeyDecVolume = 0xf841
EKeyDevice0 = 0xf842
EKeyDevice1 = 0xf843
EKeyDevice2 = 0xf844
EKeyDevice3 = 0xf845
EKeyDevice4 = 0xf846
EKeyDevice5 = 0xf847
EKeyDevice6 = 0xf848
EKeyDevice7 = 0xf849
EKeyDevice8 = 0xf84a
EKeyDevice9 = 0xf84b
EKeyDeviceA = 0xf84c
EKeyDeviceB = 0xf84d
EKeyDeviceC = 0xf84e
EKeyDeviceD = 0xf84f
EKeyDeviceE = 0xf850
EKeyDeviceF = 0xf851
EKeyApplication0 = 0xf852
EKeyApplication1 = 0xf853
EKeyApplication2 = 0xf854
EKeyApplication3 = 0xf855
EKeyApplication4 = 0xf856
EKeyApplication5 = 0xf857
EKeyApplication6 = 0xf858
EKeyApplication7 = 0xf859
EKeyApplication8 = 0xf85a
EKeyApplication9 = 0xf85b
EKeyApplicationA = 0xf85c
EKeyApplicationB = 0xf85d
EKeyApplicationC = 0xf85e
EKeyApplicationD = 0xf85f
EKeyApplicationE = 0xf860
EKeyApplicationF = 0xf861
EKeyYes = 0xf862
EKeyNo = 0xf863
EKeyIncBrightness = 0xf864
EKeyDecBrightness = 0xf865
EKeyKeyboardExtend = 0xf866
EKeyDevice10 = 0xf87
EKeyDevice11 = 0xf88
EKeyDevice12 = 0xf89
EKeyDevice13 = 0xf8a
EKeyDevice14 = 0xf8b
EKeyDevice15 = 0xf8c
EKeyDevice16 = 0xf8d
EKeyDevice17 = 0xf8e
EKeyDevice18 = 0xf8f
EKeyDevice19 = 0xf90
EKeyDevice1A = 0xf91
EKeyDevice1B = 0xf92
EKeyDevice1C = 0xf93
EKeyDevice1D = 0xf94
EKeyDevice1E = 0xf95
EKeyDevice1F = 0xf96
EKeyApplication10 = 0xf97
EKeyApplication11 = 0xf98
EKeyApplication12 = 0xf99
EKeyApplication13 = 0xf9a
EKeyApplication14 = 0xf9b
EKeyApplication15 = 0xf9c
EKeyApplication16 = 0xf9d
EKeyApplication17 = 0xf9e
EKeyApplication18 = 0xf9f
EKeyApplication19 = 0xfa0
EKeyApplication1A = 0xfa1
EKeyApplication1B = 0xfa2
EKeyApplication1C = 0xfa3
EKeyApplication1D = 0xfa4
EKeyApplication1E = 0xfa5
EKeyApplication1F = 0xfa6

EStdKeyNull=0x00
EStdKeyBackspace=0x01
EStdKeyTab=0x02
EStdKeyEnter=0x03
EStdKeyEscape=0x04
EStdKeySpace=0x05
EStdKeyPrintScreen=0x06
EStdKeyPause=0x07
EStdKeyHome=0x08
EStdKeyEnd=0x09
EStdKeyPageUp=0x0a
EStdKeyPageDown=0x0b
EStdKeyInsert=0x0c
EStdKeyDelete=0x0d
EStdKeyLeftArrow=0x0e
EStdKeyRightArrow=0x0f
EStdKeyUpArrow=0x10
EStdKeyDownArrow=0x11
EStdKeyLeftShift=0x12
EStdKeyRightShift=0x13
EStdKeyLeftAlt=0x14
EStdKeyRightAlt=0x15
EStdKeyLeftCtrl=0x16
EStdKeyRightCtrl=0x17
EStdKeyLeftFunc=0x18
EStdKeyRightFunc=0x19
EStdKeyCapsLock=0x1a
EStdKeyNumLock=0x1b
EStdKeyScrollLock=0x1c
EStdKeyF1=0x60
EStdKeyF2=0x61
EStdKeyF3=0x62
EStdKeyF4=0x63
EStdKeyF5=0x64
EStdKeyF6=0x65
EStdKeyF7=0x66
EStdKeyF8=0x67
EStdKeyF9=0x68
EStdKeyF10=0x69
EStdKeyF11=0x6a
EStdKeyF12=0x6b
EStdKeyF13=0x6c
EStdKeyF14=0x6d
EStdKeyF15=0x6e
EStdKeyF16=0x6f
EStdKeyF17=0x70
EStdKeyF18=0x71
EStdKeyF19=0x72
EStdKeyF20=0x73
EStdKeyF21=0x74
EStdKeyF22=0x75
EStdKeyF23=0x76
EStdKeyF24=0x77
EStdKeyXXX=0x78
EStdKeyComma=0x79
EStdKeyFullStop=0x7a
EStdKeyForwardSlash=0x7b
EStdKeyBackSlash=0x7c
EStdKeySemiColon=0x7d
EStdKeySingleQuote=0x7e
EStdKeyHash=0x7f
EStdKeySquareBracketLeft=0x80
EStdKeySquareBracketRight=0x81
EStdKeyMinus=0x82
EStdKeyEquals=0x83
EStdKeyNkpForwardSlash=0x84
EStdKeyNkpAsterisk=0x85
EStdKeyNkpMinus=0x86
EStdKeyNkpPlus=0x87
EStdKeyNkpEnter=0x88
EStdKeyNkp1=0x89
EStdKeyNkp2=0x8a
EStdKeyNkp3=0x8b
EStdKeyNkp4=0x8c
EStdKeyNkp5=0x8d
EStdKeyNkp6=0x8e
EStdKeyNkp7=0x8f
EStdKeyNkp8=0x90
EStdKeyNkp9=0x91
EStdKeyNkp0=0x92
EStdKeyNkpFullStop=0x93
EStdKeyMenu=0x94
EStdKeyBacklightOn=0x95
EStdKeyBacklightOff=0x96
EStdKeyBacklightToggle=0x97
EStdKeyIncContrast=0x98
EStdKeyDecContrast=0x99
EStdKeySliderDown=0x9a
EStdKeySliderUp=0x9b
EStdKeyDictaphonePlay=0x9c
EStdKeyDictaphoneStop=0x9d
EStdKeyDictaphoneRecord=0x9e
EStdKeyHelp=0x9f
EStdKeyOff=0xa0
EStdKeyDial=0xa1
EStdKeyIncVolume=0xa2
EStdKeyDecVolume=0xa3
EStdKeyDevice0=0xa4
EStdKeyDevice1=0xa5
EStdKeyDevice2=0xa6
EStdKeyDevice3=0xa7
EStdKeyDevice4=0xa8
EStdKeyDevice5=0xa9
EStdKeyDevice6=0xaa
EStdKeyDevice7=0xab
EStdKeyDevice8=0xac
EStdKeyDevice9=0xad
EStdKeyDeviceA=0xae
EStdKeyDeviceB=0xaf
EStdKeyDeviceC=0xb0
EStdKeyDeviceD=0xb1
EStdKeyDeviceE=0xb2
EStdKeyDeviceF=0xb3
EStdKeyApplication0=0xb4
EStdKeyApplication1=0xb5
EStdKeyApplication2=0xb6
EStdKeyApplication3=0xb7
EStdKeyApplication4=0xb8
EStdKeyApplication5=0xb9
EStdKeyApplication6=0xba
EStdKeyApplication7=0xbb
EStdKeyApplication8=0xbc
EStdKeyApplication9=0xbd
EStdKeyApplicationA=0xbe
EStdKeyApplicationB=0xbf
EStdKeyApplicationC=0xc0
EStdKeyApplicationD=0xc1
EStdKeyApplicationE=0xc2
EStdKeyApplicationF=0xc3
EStdKeyYes=0xc4
EStdKeyNo=0xc5
EStdKeyIncBrightness=0xc6
EStdKeyDecBrightness=0xc7
EStdKeyKeyboardExtend=0xc8
EStdKeyDevice10=0xc9
EStdKeyDevice11=0xca
EStdKeyDevice12=0xcb
EStdKeyDevice13=0xcc
EStdKeyDevice14=0xcd
EStdKeyDevice15=0xce
EStdKeyDevice16=0xcf
EStdKeyDevice17=0xd0
EStdKeyDevice18=0xd1
EStdKeyDevice19=0xd2
EStdKeyDevice1A=0xd3
EStdKeyDevice1B=0xd4
EStdKeyDevice1C=0xd5
EStdKeyDevice1D=0xd6
EStdKeyDevice1E=0xd7
EStdKeyDevice1F=0xd8
EStdKeyApplication10=0xd9
EStdKeyApplication11=0xda
EStdKeyApplication12=0xdb
EStdKeyApplication13=0xdc
EStdKeyApplication14=0xdd
EStdKeyApplication15=0xde
EStdKeyApplication16=0xdf
EStdKeyApplication17=0xe0
EStdKeyApplication18=0xe1
EStdKeyApplication19=0xe2
EStdKeyApplication1A=0xe3
EStdKeyApplication1B=0xe4
EStdKeyApplication1C=0xe5
EStdKeyApplication1D=0xe6
EStdKeyApplication1E=0xe7
EStdKeyApplication1F=0xe8	

# The following are not included in the Symbian headers.
EKey0 = 0x30
EKey1 = 0x31 
EKey2 = 0x32
EKey3 = 0x33
EKey4 = 0x34
EKey5 = 0x35
EKey6 = 0x36
EKey7 = 0x37
EKey8 = 0x38
EKey9 = 0x39
EKeyStar = 0x2a
EKeyHash = 0x23
EKeyLeftSoftkey = EKeyDevice0
EKeyRightSoftkey = EKeyDevice1
EKeySelect = EKeyDevice3
EKeyEdit = EKeyLeftShift
EKeyMenu = EKeyApplication0

EScancode0=0x30
EScancode1=0x31
EScancode2=0x32
EScancode3=0x33
EScancode4=0x34
EScancode5=0x35
EScancode6=0x36
EScancode7=0x37
EScancode8=0x38
EScancode9=0x39
EScancodeStar=0x2a
EScancodeHash=0x7f
EScancodeBackspace=0x01
EScancodeLeftSoftkey=EStdKeyDevice0
EScancodeRightSoftkey=EStdKeyDevice1
EScancodeSelect=0xa7
EScancodeYes=0xc4
EScancodeNo=0xc5
EScancodeLeftArrow=0xe
EScancodeRightArrow=0xf
EScancodeUpArrow=0x10
EScancodeDownArrow=0x11
EScancodeEdit=EStdKeyLeftShift
EScancodeMenu=EStdKeyApplication0

# Modifiers.
EModifierAutorepeatable=0x00000001
EModifierKeypad=0x00000002
EModifierLeftAlt=0x00000004
EModifierRightAlt=0x00000008
EModifierAlt=0x00000010
EModifierLeftCtrl=0x00000020
EModifierRightCtrl=0x00000040
EModifierCtrl=0x00000080
EModifierLeftShift=0x00000100
EModifierRightShift=0x00000200
EModifierShift=0x00000400
EModifierLeftFunc=0x00000800
EModifierRightFunc=0x00001000
EModifierFunc=0x00002000
EModifierCapsLock=0x00004000
EModifierNumLock=0x00008000
EModifierScrollLock=0x00010000
EModifierKeyUp=0x00020000
EModifierSpecial=0x00040000
EModifierDoubleClick=0x00080000
EModifierPureKeycode=0x00100000
EModifierKeyboardExtend=0x00200000
EModifierCancelRotation=0x00000000
EModifierRotateBy90=0x00400000
EModifierRotateBy180=0x00800000
EModifierRotateBy270=0x01000000
EModifierPointer3DButton1=0x02000000
EModifierPointer3DButton2=0x04000000
EModifierPointer3DButton3=0x08000000
EAllModifiers=0x0fffffff

# Pointer Events
EButton1Down=0x101
EButton1Up=0x102
EButton2Down=0x103
EButton2Up=0x104
EButton3Down=0x105
EButton3Up=0x106
EDrag=0x107
EMove=0x108
EButtonRepeat=0x109
ESwitchOn=0x10A
