/*
* Copyright (c) 2003 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  The MNssRecognizeEventHandler interface class handles events 
*                generated by RecognizeHandler::Recognize().
*
*/


#ifndef MNSSRECOGNIZEEVENTHANDLER_H
#define MNSSRECOGNIZEEVENTHANDLER_H

//  INCLUDES

#include <e32base.h>
#include <e32def.h>
#include "nssvasmtag.h"

// CLASS DECLARATION

/**
*
*  The MNssRecognizeEventHandler class provides the call back methods to handle 
*  the events generated by MNssRecognitionHandler::recognize().
*
*  @lib NssVASApi.lib
*  @since 2.0
*/

class MNssRecognizeEventHandler
    {

   public:  //enum

        enum TNssRecognizeError
        {
        EVasErrorNone,
        EVasRecognizeFailed,
	    EVasRecognitionFailedNoSpeech,
	    EVasRecognitionFailedTooEarly,
	    EVasRecognitionFailedTooLong,
	    EVasRecognitionFailedTooShort,
	    EVasRecognitionFailedNoMatch,
        EVasRecognizeAccessDeny,
        EVasRecognizeUndefinedError10,   // for place holder
        EVasRecognizeUndefinedError9,
        EVasRecognizeUndefinedError8,
        EVasRecognizeUndefinedError7,
        EVasRecognizeUndefinedError6,
        EVasRecognizeUndefinedError5,
        EVasRecognizeUndefinedError4,
        EVasRecognizeUndefinedError3,
        EVasRecognizeUndefinedError2,
        EVasRecognizeUndefinedError1
        };

    public: // New functions
        
        /**
        * Record Started Event - Recognizer is recording and ready to
		*                        receive the input speech
        * @since 2.0
        * @return void
        */      		
        virtual void HandleRecordStarted() = 0;

        /**
        * End Of Utterance Event - Recognizer has received the input speech
        * @since 2.0
        * @return void
        */
		virtual void HandleEouDetected() = 0;

        /**
        * Recognize Complete Event - Recognizer has analyzed the input speech.
        * @since 2.0
        * @param aClientTagList A list of recognized voice tags returned by 
		*                       Recognize. The client is responsible for 
		*                       deleting the list and its associated tags.
		* @param EVasErrorNone if recognition completed successfully
        * @return void
        */
		virtual void HandleRecognizeComplete(
           CArrayPtrFlat<MNssTag> *aClientTagList,
           TNssRecognizeError aErrorCode ) = 0;

    };

#endif      // MRECOGNIZEEVENTHANDLER_H   
            
// End of File
