// Copyright (c) 1998-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Name of test harness: T_IMCM05
// Component: IMCM
// Owner: EH
// Brief description of test harness:
// Tests the HTML resolving functions on CImEmailMessage using real files 
// generated by any mail client. It also indirectly tests that the HTML 
// parsing code is compatible with the HTML resolving code.
// Detailed description of test harness:
// As above.
// Input files required to run test harness:
// \MSG\IMCMTSRC\mainpic.msg					<DRIVE>:\msgtest\IMCM\mainpic.msg
// \MSG\IMCMTSRC\mhtml1.eml					<DRIVE>:\msgtest\IMCM\rfc822\mhtml1.eml
// \MSG\IMCMTSRC\mhtml3.eml					<DRIVE>:\msgtest\IMCM\rfc822\mhtml3.eml
// \MSG\IMCMTSRC\mhtml5.eml					<DRIVE>:\msgtest\IMCM\rfc822\mhtml5.eml
// Intermediate files produced while running test harness:
// <DRIVE>:\msglogs\T_IMCM05\T_IMCM05.LOG
// Output files produced by running test harness:
// <DRIVE>:\msglogs\T_IMCM05.<PLATFORM>.<VARIANT>.LOG.txt
// Description of how to build test harness:
// cd \msg\imcm\
// bldmake bldfiles
// abld test build
// Description of how to run test harness:
// The following instructions are the same for all platforms:
// 1. Build T_DB test harness from COMMDB component:
// cd \commdb\group
// bldmake bldfiles
// abld test build t_db
// 2. Build the test utilities:
// cd \msg\testutils\group\
// bldmake bldfiles
// abld build
// WINS running instructions:
// 1. \epoc32\release\wins\<VARIANT>\T_IMCM05.exe can be used at the command prompt
// or executable can be run from Windows Explorer.
// All other platform running instructions:
// 1. Copy \epoc32\release\<PLATFORM>\<VARIANT>\T_IMCM05.exe onto the other platform
// 2. Copy \epoc32\release\<PLATFORM>\<VARIANT>\MSVTESTUTILS.DLL into 
// <DRIVE>:\system\libs on the other platform
// 3. Copy \epoc32\release\<PLATFORM>\<VARIANT>\EMAILTESTUTILS.DLL into 
// <DRIVE>:\system\libs on the other platform
// 4. Run T_IMCM05.exe on the other platform
// 
//

#include "emailtestutils.h"
#include <miutlog.h>
#include <miutmsg.h>
#include <txtrich.h>
#include <logcli.h>
#include <logview.h>


// local variables etc //

_LIT(KImcmTest, "T_IMCM05 - Testing URI resolving of real MHTML messages");
_LIT(K_T_IMCM5_INIT, "Setting up MHTML test");
_LIT(K_T_IMCM5_FIND_FIRST, "Finding first HTML page");
_LIT(K_T_IMCM5_RESOLVE_URI, "Resolving URI");
_LIT(K_T_IMCM5_FIND_FIRST_FILE_HANDLE, "Finding first HTML page file handle");
_LIT(K_T_IMCM5_RESOLVE_URI_FILE_HANDLE, "Resolving URI File Handle");
RTest test(KImcmTest);

LOCAL_D CTrapCleanup* theCleanup;
LOCAL_D CImLog* log;
LOCAL_D CEmailTestUtils* testUtils;

_LIT(KPictureUrl1, "cid:002101bf68b6$6782dfb0$060b970a@intra");

//

LOCAL_C void Init()
	{
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler;
	CActiveScheduler::Install(scheduler);
	CleanupStack::PushL(scheduler);

	testUtils = CEmailTestUtils::NewLC(test);
	testUtils->CreateAllTestDirectories();
	testUtils->FileSession().SetSessionPath(_L("C:\\"));
	testUtils->CleanMessageFolderL();
	
	log = CImLog::NewL(_L("c:\\logs\\email\\t_imcm05.log"), EAppend);
	CleanupStack::PushL(log);
	log->AppendComment(_L8("*** T_IMCM05 Testing MHTML resolving with real message files ***"));
	TBuf8<80> buf;
#if defined(__WINS__)
	buf.Append(_L8("WINS "));
#else
	buf.Append(_L8("MARM "));
#endif
#if defined(_UNICODE)
	buf.Append(_L8("U"));
#endif
#if defined(_DEBUG)
	buf.Append(_L8("DEB"));
#else
	buf.Append(_L8("REL"));
#endif
	log->AppendComment(buf);
	}
	
LOCAL_C void Closedown()
	{
	log->AppendComment(_L8("**********    T_IMCM05 Tests Complete    **********"));
	log->AppendComment(_L8(""));

	CleanupStack::PopAndDestroy(3);  //testUtils, scheduler, log
	}

//

TMsvId loadMessageL(const TDesC& aFileName, CEmailTestUtils& aTestUtils)
	// Reset the message server
	// Clean out the message folder
	// Load the message and return its ID
	{
	aTestUtils.Reset();

	// wait a couple of seconds
	CTestTimer* timer = CTestTimer::NewL();
	timer->After(5000000);
	CActiveScheduler::Start();
	delete timer;

	aTestUtils.CleanMessageFolderL();
	aTestUtils.GoServerSideL();
	
	// Read the test message into the mail directory.
	aTestUtils.CreateMessageL(aFileName, KMsvGlobalOutBoxIndexEntryId, KMsvGlobalOutBoxIndexEntryId);
	aTestUtils.GoClientSideL();
	timer = CTestTimer::NewL();
	timer->After(5000000);
	CActiveScheduler::Start();
	delete timer;


	CMsvEntry* entry = testUtils->iMsvEntry;
	entry->SetEntryL(KMsvGlobalOutBoxIndexEntryId);
	CMsvEntrySelection* newMessageList = entry->ChildrenL();
	CleanupStack::PushL(newMessageList);
	TMsvId newMessage = (*newMessageList)[0];
	CleanupStack::PopAndDestroy(); // newMessageList

	return newMessage;
	}

//

LOCAL_C void doMainL()
	{
	Init();
	CTestActive* testActive = new CTestActive;
	CleanupStack::PushL(testActive);
	TInt globalError = KErrNone;
	TInt error;

	testUtils->WriteComment(KImcmTest);
	testUtils->FileSession().SetSessionPath(_L("c:\\"));

	testUtils->WriteComment(K_T_IMCM5_INIT);

	CImEmailMessage* emailMessage;
	TMsvId newMessage;
	TBool found;
	TMsvId newEntryId;
	TMsvId firstPageId;
	TFileName fileCompareName;
	RFile file;
	HBufC* fileName;

// Test message #1

	// Read the test message into the mail directory.
	newMessage = loadMessageL(_L("c:\\mailtest\\mainpic.msg"), *testUtils);
	
	// Set up the emailMessage object
	emailMessage = CImEmailMessage::NewLC(*(testUtils->iMsvEntry));

	testUtils->TestStart(0, K_T_IMCM5_FIND_FIRST);
	// Find the first HTML page.
	testActive->StartL();
	emailMessage->FindFirstHTMLPageL(newMessage, testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	CleanupStack::PushL(fileName);
	// Check we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\Private\\1000484b\\Mail2\\00001001_S\\4\\00100004_F\\Attachment.html")) == 0) ? KErrNone : KErrNotFound;	
	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(0, error);
	if (globalError == KErrNone)
		globalError = error;

	testUtils->TestStart(1, K_T_IMCM5_RESOLVE_URI);
	// Find the picture.
	testActive->StartL();
	emailMessage->FindUniversalResourceIdentifierL(newEntryId, _L(""), KPictureUrl1, testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	CleanupStack::PushL(fileName);
	// Check that we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\private\\1000484b\\Mail2\\00001001_S\\5\\00100005_F\\logo1.gif")) == 0) ? KErrNone : KErrNotFound;

	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(1, error);
	if (globalError == KErrNone)
		globalError = error;
	
	CleanupStack::PopAndDestroy(emailMessage);

//

// Test message #2

	// Read the test message into the mail directory.
	newMessage = loadMessageL(_L("c:\\mailtest\\rfc822\\mhtml1.eml"), *testUtils);
	emailMessage = CImEmailMessage::NewLC(*(testUtils->iMsvEntry));

	testUtils->TestStart(2, K_T_IMCM5_FIND_FIRST);
	// Find the first HTML page.
	testActive->StartL();
	emailMessage->FindFirstHTMLPageL(newMessage, testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	CleanupStack::PushL(fileName);
	// Check we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\private\\1000484b\\Mail2\\00001001_S\\3\\00100003_F\\Attachment.html")) == 0 ) ? KErrNone : KErrNotFound;
	
	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(2, error);
	if (globalError == KErrNone)
		globalError = error;

	// Test quoted content-location values.
	testUtils->TestStart(3, K_T_IMCM5_RESOLVE_URI);
	testActive->StartL();
	emailMessage->FindUniversalResourceIdentifierL(newEntryId, _L(""), _L("/styles.css"), testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	CleanupStack::PushL(fileName);
	// Check that we have not got the file, but a URI.
	testUtils->Test()(!found);
	error = ((*fileName).CompareF(_L("http://www.nokia.com/styles.css")) == 0 ) ? KErrNone : KErrNotFound;

	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(3, error);
	if (globalError == KErrNone)
		globalError = error;
	
	CleanupStack::PopAndDestroy(emailMessage);

//

// Test message #3

	// Read the test message into the mail directory.
	newMessage = loadMessageL(_L("c:\\mailtest\\rfc822\\mhtml5.eml"), *testUtils);
	emailMessage = CImEmailMessage::NewLC(*(testUtils->iMsvEntry));

	testUtils->TestStart(4, K_T_IMCM5_FIND_FIRST);
	// Find the first HTML page.
	testActive->StartL();
	emailMessage->FindFirstHTMLPageL(newMessage, testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	firstPageId = newEntryId;
	CleanupStack::PushL(fileName);
	// Check we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\private\\1000484b\\Mail2\\00001001_S\\5\\00100005_F\\Attachment.html")) == 0) ? KErrNone : KErrNotFound;	

	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(4, error);
	if (globalError == KErrNone)
		globalError = error;
	
	testUtils->TestStart(5, K_T_IMCM5_RESOLVE_URI);
	testActive->StartL();
	emailMessage->FindUniversalResourceIdentifierL(newEntryId, _L(""), _L("http://www.nokia.com/pics/releasemore.gif"), testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	CleanupStack::PushL(fileName);
	// Check that we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\private\\1000484b\\Mail2\\00001001_S\\3\\00100013_F\\Attachment.gif")) == 0 ) ? KErrNone : KErrNotFound;	

	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(5, error);
	if (globalError == KErrNone)
		globalError = error;
	
	testUtils->TestStart(6, K_T_IMCM5_RESOLVE_URI);
	testActive->StartL();
	newEntryId = firstPageId;
	emailMessage->FindUniversalResourceIdentifierL(newEntryId, _L(""), _L("pics/102_grey_1px.gif"), testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	CleanupStack::PushL(fileName);
	// Check that we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\private\\1000484b\\Mail2\\00001001_S\\a\\0010000a_F\\Attachment.gif")) == 0 ) ? KErrNone : KErrNotFound;	

	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(6, error);
	if (globalError == KErrNone)
		globalError = error;
	
	testUtils->TestStart(7, K_T_IMCM5_RESOLVE_URI);
	testActive->StartL();
	newEntryId = firstPageId;
	emailMessage->FindUniversalResourceIdentifierL(newEntryId, _L(""), _L("/pics/snow_small.gif"), testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	CleanupStack::PushL(fileName);
	// Check that we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\private\\1000484b\\Mail2\\00001001_S\\6\\00100006_F\\Attachment.gif")) == 0 ) ? KErrNone : KErrNotFound;	

	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(7, error);
	if (globalError == KErrNone)
		globalError = error;
	
	CleanupStack::PopAndDestroy(emailMessage);

//

// Test message #4
// Hotmail message

	// Read the test message into the mail directory.
	newMessage = loadMessageL(_L("c:\\mailtest\\rfc822\\mhtml3.eml"), *testUtils);
	emailMessage = CImEmailMessage::NewLC(*(testUtils->iMsvEntry));

	testUtils->TestStart(8, K_T_IMCM5_FIND_FIRST);
	// Find the first HTML page.
	testActive->StartL();
	emailMessage->FindFirstHTMLPageL(newMessage, testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	firstPageId = newEntryId;
	CleanupStack::PushL(fileName);
	// Check we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\private\\1000484b\\Mail2\\00001001_S\\4\\00100004_F\\Attachment.html")) == 0 ) ? KErrNone : KErrNotFound; // eh xxxx, needs updating

	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(8, error);
	if (globalError == KErrNone)
		globalError = error;
	
	testUtils->TestStart(9, K_T_IMCM5_RESOLVE_URI);
	testActive->StartL();
	newEntryId = firstPageId;
	emailMessage->FindUniversalResourceIdentifierL(newEntryId, _L(""), _L("cid:part_00$2c587273$285c5f6d@hotmail.com"), testActive->iStatus);
	CActiveScheduler::Start();
	fileName = emailMessage->GetUniversalResourceIdentifierL(newEntryId, found);
	CleanupStack::PushL(fileName);
	// Check that we've got the right one.
	testUtils->Test()(found);
	error = ((*fileName).CompareF(_L("C:\\private\\1000484b\\Mail2\\00001001_S\\5\\00100005_F\\Attachment.gif")) == 0 ) ? KErrNone : KErrNotFound;  // eh xxxx, needs updating

	CleanupStack::PopAndDestroy(fileName);
	testUtils->TestFinish(9, error);
	if (globalError == KErrNone)
		globalError = error;
	
	CleanupStack::PopAndDestroy(emailMessage); 

//
// Test message #5

	// Read the test message into the mail directory.
	newMessage = loadMessageL(_L("c:\\mailtest\\mainpic.msg"), *testUtils);
	
	// Set up the emailMessage object
	emailMessage = CImEmailMessage::NewLC(*(testUtils->iMsvEntry));
	
	testUtils->TestStart(10, K_T_IMCM5_FIND_FIRST_FILE_HANDLE);
	// Find the first HTML page.
	testActive->StartL();
	emailMessage->FindFirstHTMLPageFileHandleL(newMessage, testActive->iStatus);
	CActiveScheduler::Start();
	
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	CleanupClosePushL(file);
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("Attachment.html"))==0);
	CleanupStack::PopAndDestroy(&file); 
	
	testUtils->TestFinish(10, error);
	if (globalError == KErrNone)
		globalError = error;
	
	testUtils->TestStart(11, K_T_IMCM5_RESOLVE_URI_FILE_HANDLE);
	// Find the picture.
	testActive->StartL();
	emailMessage->FindUniversalResourceIdentifierFileHandleL(newEntryId, _L(""), KPictureUrl1, testActive->iStatus);
	CActiveScheduler::Start();
	
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	CleanupClosePushL(file);
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("logo1.gif"))==0);
	CleanupStack::PopAndDestroy(&file);
	
	testUtils->TestFinish(11, error);
	if (globalError == KErrNone)
		globalError = error;

	CleanupStack::PopAndDestroy(emailMessage);
	
// Test message #6

	// Read the test message into the mail directory.
	newMessage = loadMessageL(_L("c:\\mailtest\\rfc822\\mhtml1.eml"), *testUtils);
	emailMessage = CImEmailMessage::NewLC(*(testUtils->iMsvEntry));

	testUtils->TestStart(12, K_T_IMCM5_FIND_FIRST_FILE_HANDLE);
	// Find the first HTML page.
	testActive->StartL();
	emailMessage->FindFirstHTMLPageFileHandleL(newMessage, testActive->iStatus);
	CActiveScheduler::Start();	
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	CleanupClosePushL(file);
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("Attachment.html"))==0);
	CleanupStack::PopAndDestroy(&file);
	
	testUtils->TestFinish(12, error);
	if (globalError == KErrNone)
		globalError = error;
		

	// Test quoted content-location values.
	testUtils->TestStart(13, K_T_IMCM5_RESOLVE_URI_FILE_HANDLE);
	testActive->StartL();
	emailMessage->FindUniversalResourceIdentifierFileHandleL(newEntryId, _L(""), _L("/styles.css"), testActive->iStatus);
	CActiveScheduler::Start();
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNotFound);
	testUtils->TestFinish(13, error);
	if (globalError == KErrNone)
		globalError = error;

	CleanupStack::PopAndDestroy(emailMessage);
	
	
//

// Test message #7

	// Read the test message into the mail directory.
	newMessage = loadMessageL(_L("c:\\mailtest\\rfc822\\mhtml5.eml"), *testUtils);
	emailMessage = CImEmailMessage::NewLC(*(testUtils->iMsvEntry));

	testUtils->TestStart(14, K_T_IMCM5_FIND_FIRST_FILE_HANDLE);
	// Find the first HTML page.
	testActive->StartL();
	emailMessage->FindFirstHTMLPageFileHandleL(newMessage, testActive->iStatus);
	CActiveScheduler::Start();
	
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	CleanupClosePushL(file);
	firstPageId = newEntryId;
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("Attachment.html"))==0);
	CleanupStack::PopAndDestroy(&file);
	
	testUtils->TestFinish(14, error);
	if (globalError == KErrNone)
		globalError = error;

	testUtils->TestStart(15, K_T_IMCM5_RESOLVE_URI_FILE_HANDLE);
	testActive->StartL();
	emailMessage->FindUniversalResourceIdentifierFileHandleL(newEntryId, _L(""), _L("http://www.nokia.com/pics/releasemore.gif"), testActive->iStatus);
	CActiveScheduler::Start();
	
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	CleanupClosePushL(file);
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("Attachment.gif"))==0);
	CleanupStack::PopAndDestroy(&file);
	
	testUtils->TestFinish(15, error);
	if (globalError == KErrNone)
		globalError = error;
	
	testUtils->TestStart(16, K_T_IMCM5_RESOLVE_URI_FILE_HANDLE);
	testActive->StartL();
	newEntryId = firstPageId;
	emailMessage->FindUniversalResourceIdentifierFileHandleL(newEntryId, _L(""), _L("pics/102_grey_1px.gif"), testActive->iStatus);
	CActiveScheduler::Start();
		
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	CleanupClosePushL(file);
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("Attachment.gif"))==0);
	CleanupStack::PopAndDestroy(&file);
	
	testUtils->TestFinish(16, error);
	if (globalError == KErrNone)
		globalError = error;
	
	testUtils->TestStart(17, K_T_IMCM5_RESOLVE_URI_FILE_HANDLE);
	testActive->StartL();
	newEntryId = firstPageId;
	emailMessage->FindUniversalResourceIdentifierFileHandleL(newEntryId, _L(""), _L("/pics/snow_small.gif"), testActive->iStatus);
	CActiveScheduler::Start();
	
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	CleanupClosePushL(file);
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("Attachment.gif"))==0);
	CleanupStack::PopAndDestroy(&file);
	
	testUtils->TestFinish(17, error);
	if (globalError == KErrNone)
		globalError = error;

	CleanupStack::PopAndDestroy(emailMessage);

//

// Test message #8
// Hotmail message

	// Read the test message into the mail directory.
	newMessage = loadMessageL(_L("c:\\mailtest\\rfc822\\mhtml3.eml"), *testUtils);
	emailMessage = CImEmailMessage::NewLC(*(testUtils->iMsvEntry));

	testUtils->TestStart(18, K_T_IMCM5_FIND_FIRST_FILE_HANDLE);
	// Find the first HTML page.
	testActive->StartL();
	emailMessage->FindFirstHTMLPageFileHandleL(newMessage, testActive->iStatus);
	CActiveScheduler::Start();
	
	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	firstPageId = newEntryId;
	CleanupClosePushL(file);
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("Attachment.html"))==0);
	CleanupStack::PopAndDestroy(&file);
	
	testUtils->TestFinish(18, error);
	if (globalError == KErrNone)
		globalError = error;

	testUtils->TestStart(19, K_T_IMCM5_RESOLVE_URI_FILE_HANDLE);
	testActive->StartL();
	newEntryId = firstPageId;
	emailMessage->FindUniversalResourceIdentifierFileHandleL(newEntryId, _L(""), _L("cid:part_00$2c587273$285c5f6d@hotmail.com"), testActive->iStatus);
	CActiveScheduler::Start();

	testUtils->Test()(emailMessage->GetUniversalResourceIdentifierFileHandle(newEntryId, file) == KErrNone);
	CleanupClosePushL(file);
	testUtils->Test()(file.Name(fileCompareName)==KErrNone);
	testUtils->Test()(fileCompareName.CompareF(_L("Attachment.gif"))==0);
	CleanupStack::PopAndDestroy(&file);
	
	testUtils->TestFinish(19, error);
	if (globalError == KErrNone)
		globalError = error;

	CleanupStack::PopAndDestroy(emailMessage); 


	CleanupStack::PopAndDestroy(testActive);

	if (globalError == KErrNone)
		testUtils->TestHarnessCompleted();
	else
		testUtils->TestHarnessFailed(globalError);

	Closedown();
	}

GLDEF_C TInt E32Main()
	{	
	__UHEAP_MARK;
	test.Start(KImcmTest);
	theCleanup=CTrapCleanup::New();
	TRAPD(ret,doMainL());		
	test(ret==KErrNone);
	delete theCleanup;	
	test.End();
	test.Close();
	__UHEAP_MARKEND;
	User::Heap().Check();
	return(KErrNone);
	}
