/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 */

#ifndef UNI_VIEWER_ADDRESS_WIDGET_H
#define UNI_VIEWER_ADDRESS_WIDGET_H

// SYSTEM INCLUDES
#include <HbWidget>

// USER INCLUDES
#include "convergedmessageaddress.h"

// FORWARD DECLARATIONS
class QPointF;
class HbMenu;
class UniTextEditor;

class UniViewerAddressWidget : public HbWidget
{
Q_OBJECT

public:

    /**
     * Constructor
     */
    explicit UniViewerAddressWidget(QGraphicsItem *parent = 0);

    /**
     * Destructor
     */
    virtual ~UniViewerAddressWidget();

    /**
     * Populates the addresses and creates the anchors on them.
     * @param label Label of the address like - "From"
     * @param address Address string to be populated.
     */
    void populate(const QString &label, const QString &address, const QString &alias);

    /**
     * Populates the addresses and creates the anchors on them.
     * @param label Label of the address like - "To", "Cc"
     * @param addressList List of addresses to be populated.
     */
    void populate(const QString &label,
                ConvergedMessageAddressList addressList);

    /**
     * Clears the contents of the widget.
     */
    void clearContent();

private slots:

    /**
     * Handles the aboutToShowContextMenu() signal generated by HbAbstractEdit.
     * @see HbAbstractEdit
     * @param contextMenu Reference of the context menu.
     * @param pos Position at which the context menu will be displayed.
     */
    void handleAboutToShowContextMenu(HbMenu *contextMenu, const QPointF &pos);

private:

    /**
     * Reference of the editor.
     * Own
     */
    UniTextEditor *mAddress;
};

#endif // UNI_VIEWER_ADDRESS_WIDGET_H
// EOF
