/*
* Copyright (c) 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Language tag constants for SVP.
*
*/



#ifndef SVPLANGUAGETAGCONSTS_H
#define SVPLANGUAGETAGCONSTS_H

// Language tags, needed for mapping Symbian language codes
// to language tags (ISO 639-1)
_LIT8( KSVPLanguageTagEn, "en" ); // english 
_LIT8( KSVPLanguageTagFr, "fr" ); // french
_LIT8( KSVPLanguageTagDe, "de" ); // german
_LIT8( KSVPLanguageTagEs, "es" ); // spanish
_LIT8( KSVPLanguageTagIt, "it" ); // italian
_LIT8( KSVPLanguageTagSv, "sv" ); // swedish
_LIT8( KSVPLanguageTagDa, "da" ); // danish
_LIT8( KSVPLanguageTagNo, "no" ); // norwegian
_LIT8( KSVPLanguageTagFi, "fi" ); // finnish
_LIT8( KSVPLanguageTagAmerican, "en" ); // american english
_LIT8( KSVPLanguageTagSwissFrench, "fr" ); // swiss french
_LIT8( KSVPLanguageTagSwissGerman, "de" ); // swiss german
_LIT8( KSVPLanguageTagPt, "pt" ); // portugese
_LIT8( KSVPLanguageTagTr, "tr" ); // turkish
_LIT8( KSVPLanguageTagIs, "is" ); // icelandic
_LIT8( KSVPLanguageTagRu, "ru" ); // russian
_LIT8( KSVPLanguageTagHu, "hu" ); // hungarian
_LIT8( KSVPLanguageTagNl, "nl" ); // dutch
_LIT8( KSVPLanguageTagBelgianFlemish, "nl" ); // belgian flemish
_LIT8( KSVPLanguageTagAustralian, "en" ); // australian english
_LIT8( KSVPLanguageTagESVPLangBelgianFrench, "fr" ); // belgian french
_LIT8( KSVPLanguageTagESVPLangAustrianGerman, "de" ); // austrian german
_LIT8( KSVPLanguageTagESVPLangNewZealandEnglish, "en" ); // new zealand english
_LIT8( KSVPLanguageTagESVPLangInternationalFrench, "fr" ); // international french
_LIT8( KSVPLanguageTagCs, "cs" ); // czech
_LIT8( KSVPLanguageTagSk, "sk" ); // slovak
_LIT8( KSVPLanguageTagPl, "pl" ); // polish
_LIT8( KSVPLanguageTagSl, "sl" ); // slovenian
_LIT8( KSVPLanguageTagTaiwaneseChinese, "zh" ); // taiwanese chinese
_LIT8( KSVPLanguageTagHongKongChinese, "zh" ); // hong kong chinese
_LIT8( KSVPLanguageTagChinese, "zh" ); //  republic of china's chinese
_LIT8( KSVPLanguageTagJa, "ja" ); // japanese
_LIT8( KSVPLanguageTagTh, "th" ); // thai
_LIT8( KSVPLanguageTagAf, "af" ); // afrikaans
_LIT8( KSVPLanguageTagSq, "sq" ); // albanian
_LIT8( KSVPLanguageTagAm, "am" ); // amharic
_LIT8( KSVPLanguageTagAr, "ar" ); // arabic
_LIT8( KSVPLanguageTagHy, "hy" ); // armenian
_LIT8( KSVPLanguageTagTl, "tl" ); // tagalog
_LIT8( KSVPLanguageTagBe, "be" ); // belarussian
_LIT8( KSVPLanguageTagBn, "bn" ); // bengali
_LIT8( KSVPLanguageTagBg, "bg" ); // bulgarian
_LIT8( KSVPLanguageTagMy, "my" ); // burmese
_LIT8( KSVPLanguageTagCa, "ca" ); // catalan
_LIT8( KSVPLanguageTagHr, "hr" ); // croatian
_LIT8( KSVPLanguageTagCanadianEnglish, "en" ); // canadian english
_LIT8( KSVPLanguageTagInternationalEnglish, "en" ); // international english
_LIT8( KSVPLanguageTagSouthAfricanEnglish, "en" ); // south african english
_LIT8( KSVPLanguageTagEt, "et" ); // estonian
_LIT8( KSVPLanguageTagFa, "fa" ); // farsi
_LIT8( KSVPLanguageTagCanadianFrench, "fr" ); // canadian french
_LIT8( KSVPLanguageTagGd, "gd" ); // gaelic
_LIT8( KSVPLanguageTagKa, "ka" ); // georgian
_LIT8( KSVPLanguageTagEl, "el" ); // greek
_LIT8( KSVPLanguageTagCyprusGreek, "el" ); // cyprus greek
_LIT8( KSVPLanguageTagGu, "gu" ); // gujarati
_LIT8( KSVPLanguageTagHe, "he" ); // hebrew
_LIT8( KSVPLanguageTagHi, "hi" ); // hindi
_LIT8( KSVPLanguageTagId, "id" ); // indonesian
_LIT8( KSVPLanguageTagGa, "ga" ); // irish
_LIT8( KSVPLanguageTagSwissItalian, "it" ); // swiss italian
_LIT8( KSVPLanguageTagKn, "kn" ); // kannada
_LIT8( KSVPLanguageTagKk, "kk" ); // kazakh
_LIT8( KSVPLanguageTagKm, "km" ); // khmer  
_LIT8( KSVPLanguageTagKo, "ko" ); // korean
_LIT8( KSVPLanguageTagLo, "lo" ); // lao
_LIT8( KSVPLanguageTagLv, "lv" ); // latvian
_LIT8( KSVPLanguageTagLt, "lt" ); // lithuanian
_LIT8( KSVPLanguageTagMk, "mk" ); // macedonian
_LIT8( KSVPLanguageTagMs, "ms" ); // malay
_LIT8( KSVPLanguageTagMl, "ml" ); // malayam
_LIT8( KSVPLanguageTagMr, "mr" ); // marathi
_LIT8( KSVPLanguageTagMo, "mo" ); // moldovian
_LIT8( KSVPLanguageTagMn, "mn" ); // mongolian
_LIT8( KSVPLanguageTagNorwegianNynorsk, "no" ); // norwegian nynorsk
_LIT8( KSVPLanguageTagBrazilianPortugese, "pt" ); // brazilian portugese
_LIT8( KSVPLanguageTagPa, "pa" ); // punjabi
_LIT8( KSVPLanguageTagRo, "ro" ); // romanian
_LIT8( KSVPLanguageTagSr, "sr" ); // serbian
_LIT8( KSVPLanguageTagSi, "si" ); // sinhalese
_LIT8( KSVPLanguageTagSo, "so" ); // somali
_LIT8( KSVPLanguageTagInternationalSpanish, "es" ); // international spanish
_LIT8( KSVPLanguageTagAmericanSpanish, "es" ); // american spanish
_LIT8( KSVPLanguageTagSw, "sw" ); // swahili
_LIT8( KSVPLanguageTagFinlandSwedish, "fi" ); // finland swedish
_LIT8( KSVPLanguageTagReserved, " " ); // Reserved for future use
_LIT8( KSVPLanguageTagTa, "ta" ); // tamil
_LIT8( KSVPLanguageTagTe, "te" ); // telugu
_LIT8( KSVPLanguageTagBo, "bo" ); // tibetan
_LIT8( KSVPLanguageTagTi, "ti" ); // tigrinya
_LIT8( KSVPLanguageTagCyprusTurkish, "tr" ); // cyprus turkish
_LIT8( KSVPLanguageTagTurkaem, " " ); // turkaem 
_LIT8( KSVPLanguageTagUk, "uk" ); // ukrainian
_LIT8( KSVPLanguageTagUr, "ur" ); // urdu
_LIT8( KSVPLanguageTagReserved2, " " ); // reserved for future use 2
_LIT8( KSVPLanguageTagVi, "vi" ); // vietnamese
_LIT8( KSVPLanguageTagCy, "cy" ); // welsh
_LIT8( KSVPLanguageTagZu, "zu" ); // zulu
_LIT8( KSVPLanguageTagSoth, "LS"); // lesotho
_LIT8( KSVPLanguageTagMalay, "ms"); // malay

// enumeration for Symbian supported languages
enum TLanguageTags
    {
    ESVPLangTest, // not used
    ESVPLangEnglish, 
    ESVPLangFrench, 
    ESVPLangGerman, 
    ESVPLangSpanish,
    ESVPLangItalian, 
    ESVPLangSwedish, 
    ESVPLangDanish, 
    ESVPLangNorwegian, 
    ESVPLangFinnish, 
    ESVPLangAmerican, 
    ESVPLangSwissFrench, 
    ESVPLangSwissGerman,
    ESVPLangPortuguese, 
    ESVPLangTurkish, 
    ESVPLangIcelandic, 
    ESVPLangRussian,
    ESVPLangHungarian,
    ESVPLangDutch,
    ESVPLangBelgianFlemish,
    ESVPLangAustralian,
    ESVPLangBelgianFrench,
    ESVPLangAustrian,
    ESVPLangNewZealand,
    ESVPLangInternationalFrench,
    ESVPLangCzech,
    ESVPLangSlovak,
    ESVPLangPolish,
    ESVPLangSlovenian,
    ESVPLangTaiwanChinese,
    ESVPLangHongKongChinese,
    ESVPLangPrcChinese,
    ESVPLangJapanese,
    ESVPLangThai,
    ESVPLangAfrikaans,
    ESVPLangAlbanian,
    ESVPLangAmharic,
    ESVPLangArabic,
    ESVPLangArmenian,
    ESVPLangTagalog,
    ESVPLangBelarussian,
    ESVPLangBengali,
    ESVPLangBulgarian,
    ESVPLangBurmese,
    ESVPLangCatalan,
    ESVPLangCroatian,
    ESVPLangCanadianEnglish,
    ESVPLangInternationalEnglish,
    ESVPLangSouthAfricanEnglish,
    ESVPLangEstonian,
    ESVPLangFarsi,
    ESVPLangCanadianFrench,
    ESVPLangScotsGaelic,
    ESVPLangGeorgian,
    ESVPLangGreek,
    ESVPLangCyprusGreek,
    ESVPLangGujarati,
    ESVPLangHebrew,
    ESVPLangHindi,
    ESVPLangIndonesian,
    ESVPLangIrish,
    ESVPLangSwissItalian,
    ESVPLangKannada,
    ESVPLangKazakh,
    ESVPLangKhmer,
    ESVPLangKorean,
    ESVPLangLao,
    ESVPLangLatvian,
    ESVPLangLithuanian,
    ESVPLangMacedonian,
    ESVPLangMalay,
    ESVPLangMalayalam,
    ESVPLangMarathi,
    ESVPLangMoldavian,
    ESVPLangMongolian,
    ESVPLangNorwegianNynorsk,
    ESVPLangBrazilianPortuguese,
    ESVPLangPunjabi,
    ESVPLangRomanian,
    ESVPLangSerbian,
    ESVPLangSinhalese,
    ESVPLangSomali,
    ESVPLangInternationalSpanish,
    ESVPLangLatinAmericanSpanish,
    ESVPLangSwahili,
    ESVPLangFinlandSwedish,
    ESVPLangReserved1,
    ESVPLangTamil,
    ESVPLangTelugu,
    ESVPLangTibetan,
    ESVPLangTigrinya,
    ESVPLangCyprusTurkish,
    ESVPLangTurkmen,
    ESVPLangUkrainian,
    ESVPLangUrdu,
    ESVPLangReserved2,
    ESVPLangVietnamese,
    ESVPLangWelsh,
    ESVPLangZulu,
    ESVPLangOther,
	ESVPLangManufacturerEnglish,
	ESVPLangSouthSotho,
	ESVPLangEnglish_Apac = 129,
	ESVPLangEnglish_Taiwan = 157,
	ESVPLangEnglish_HongKong = 158,
	ESVPLangEnglish_Prc = 159,
	ESVPLangEnglish_Japan = 160,
	ESVPLangEnglish_Thailand = 161,
	ESVPLangMalay_Apac = 326,
    ESVPLangMaximum = 0xFFFE,
    ESVPLangNone = 0xFFFF
    };
    
#endif // SVPLANGUAGETAGCONSTS_H
