/*
* Copyright (c) 2004 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Pure data handler abstract interface
*
*/

#ifndef __MPENGPUREDATAHANDLER_H__
#define __MPENGPUREDATAHANDLER_H__


//  INCLUDES
#include <E32Std.h>

// DATA TYPES



// FORWARD DECLARATIONS


// CLASS DECLARATION
/**
 *  Pure data handler for network session
 *
 *  It is used to send requests to the network
 *  server and to retrieve its responses
 *
 *  @since 3.0
 */
class MPEngPureDataHandler
    {

    public: //

        /**
         *  Close reference to the Pure data handler
         *  Pure data halder is deleted if it is no more needed.
         *
         *  @since 3.0
         */
        virtual void Close() = 0;

        /**
         *  Get Transfer buffer for out going message
         *
         *  @since 3.0
         *  @return writable data buffer
         */
        virtual TPtr8 TransferBufferL() = 0;

        /**
         *  Sends data from the transfer buffer to the network
         *  Completion code is signaled in TRequestStatus complete
         *
         *  @since 3.0
         *  @param aStatus TRequestStatus to signal completion
         *  @return unique code of the transaction. Same code is
         *          used, when client wants to get response to this
         *          message
         */
        virtual TInt SendDataL( TRequestStatus& aStatus ) = 0;

        /**
         *  Gets response for the message of given operation id
         *
         *  @since 3.0
         *  @param aTransId transaction Id generated by the send operation
         *  @return buffer with the response to the transaction
         *          ownership of the buffer is passed to the user of function
         */
        virtual HBufC8* ResponseL( TInt aTransId ) = 0;

        /**
         *  Cancel sendin operation of given transaction id
         *
         *  @since 3.0
         *
         *  @param aTransId transaction id of operation to be canceled
         */
        virtual void CancelSending( TInt aTransId ) = 0;

        /**
         *  Listen Incoming data
         *  Function returns number of incoming data buffer which
         *  are queued on the client side and can be picked
         *  when incoming data are picked by the listener, transaction
         *  is is 0. Buffer of incoming data is FIFO
         *
         *  @since 3.0
         *  @param request status to signal new data
         *  @return number of the incoming data buffers
         *      which are already ready to be picked by the listener
         */
        virtual TInt ListenIncomingData( TRequestStatus& aStatus ) = 0;

        /**
         *  Cancel incoming data listening
         *
         *  @since 3.0
         *  @param
         *  @return
         */
        virtual void CancelListening() = 0;

    protected:  //Destructor

        /**
         *  Virtual inline destructor.
         *  Protected destructor to prohibits deletion trough interface.
         */
        virtual ~MPEngPureDataHandler() {};
    };


#endif      //  __MPENGPUREDATAHANDLER_H__

//  End of File



