/*
* Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Container for recorded chats list view.
*
*/




#ifndef CCARECORDEDCHATSLISTVIEWCONTAINER_H
#define CCARECORDEDCHATSLISTVIEWCONTAINER_H

// INCLUDES
#include "MCALayoutChangeObserver.h"

#include <AknProgressDialog.h> //MProgressDialogCallBack
#include <eiklbo.h> //MEikListBoxObserver
#include <coecntrl.h>

// FORWARD DECLARATIONS
class CAknDoubleGraphicStyleListBox;
class MCAViewSwitcher;
class CCAAppUi;
class CCARecordedChatsArray;
//class CEikMenuBar;
class MCARecordedChatsPC;
class MCARecipientObserver;


// CLASS DECLARATION

/**
 *  This class container class for chat list view
 *
 *  @lib chatng.app
 *  @since 3.2
 */
class CCARecordedChatsListViewContainer :   public CCoeControl,
            public MEikListBoxObserver,
            public MCALayoutChangeObserver,
            public MProgressDialogCallback
    {

    public: // Constructors and destructor

        /**
         * Symbian constructor
         * @param aRect Frame rectangle for container.
         * @param aAppUi: reference to the App Ui instance
         * @param aViewSwitcher Handle to view-switcher
         * @param aRecordedChatsArray Array of listed items
         * @param aLastIndex Selected index.
         * @return Instance of CCARecordedChatListViewContainer
         *
         */
        static CCARecordedChatsListViewContainer* NewL(
            MCARecipientObserver& aMenuObserver,
            const TRect& aRect,
            CCAAppUi& aAppUi,
            MCAViewSwitcher& aViewSwitcher,
            CCARecordedChatsArray& aRecordedChatsArray,
            TInt aLastIndex,
            TBool& aContextFlag );

        /**
         * Symbian OS default constructor.
         * @param aRect Frame rectangle for container.
         * @param aLastIndex Selected index.
         */
        void ConstructL(    const TRect& aRect,
                            TInt aLastIndex  );

        /**
         * Destructor.
         */
        virtual ~CCARecordedChatsListViewContainer();

    public: // New functions
        /**
         * Returns name of currently highlighted recorde chat.
         * @since S60 v3.2
         * @return Name of highlighted recording.
         */
        const TDesC& HighlightedChatName() const;


        /**
         * Returns handle to the chat list listbox
         * @return Handle to listbox
         */
        CAknDoubleGraphicStyleListBox* ListBox();

        /**
         * If marked items, delete those. Otherwise current selected is deleted.
         */
        void DeleteHistoryFilesL();

        /**
         * Opens current record if possible.
         */
        void OpenRecordL();

        /**
         *	Mark/unmark all items
         *  @param aMark ETrue, mark all. EFalse unmark all.
         */
        void MarkAllL( TBool aMark );

        /**
         *  Mark/unmark index item
         *  @param aIndex Item index
         *  @param aMark ETrue, mark item. EFalse unmark item.
         */
        void MarkL( TInt aIndex, TBool aMark );
		
        /**
         * Set the moving flag.
         */
        void SetMovingFlag( TBool aFlag );

    private: //New functions

        /**
         * Sets the default title of this view
         */
        void SetDefaultTitleL();

        /**
         *	Loads bitmaps for this view.
         */
        void LoadBitmapsL();

        /**
         *	Show progressdialog.
         */
        void ShowProgressDialogL();

        /**
         *	Update progress dialog text
         */
        void UpdateProgressTextL();

        /**
         *	Shutdown progressdialog
         */
        void DismissProgressDialogL();

        /**
         * Callback method for idle class. Idle calls this when needed.
         * This is used to control idle running.
         * return 1, if idle is needed and 0 if not.
         */
        static TInt IdleDeleteCallback( TAny* aThis );

        /**
         * Updates CBA.
         * @since S60 v3.2
         */
        void UpdateCbaL();

    private: // Functions from base classes

        /**
         * @see MCALayoutChangeObserver
         */
        void LayoutChangedL( TInt aType );

        /**
         * From MEikListBoxObserver, Handles event's generated by listbox
         * @param aListBox Pointer to listbox from where this event originated
         * @param aEventType Type of event received.
         * @see MEikListBoxObserver
         */
        void HandleListBoxEventL(	CEikListBox* aListBox,
                                  TListBoxEvent aEventType );

        /**
         * From CoeControl, Handles "size changed"-events..
         * @see CoeControl
         */
        void SizeChanged();

        /**
         * From CoeControl, Returns the number of control
         * contained by this class.
         * @return Number of controls contained
         * @see CoeControl
         */
        TInt CountComponentControls() const;

        /**
         * From CCoeControl, Returns handle to control pointed by aIndex
         * @see CoeControl
         * @param aIndex Wanted control's index [0..n]
         * @return Handle to wanted control
         */
        CCoeControl* ComponentControl( TInt aIndex ) const;

        /**
         * From CCoeControl, Handles key-events
         * @see CoeControl
         * @param aEvent Event that occured
         * @param aType Type of key-event
         *              (EEventKey, EEventKeyUp or EEventKeyDown)
         * @return Containers response to event
         *         (EKeyWasNotConsumed/ EKeyWasConsumed)
         */
        TKeyResponse OfferKeyEventL( const TKeyEvent& aEvent,
                                     TEventCode aType );

        /**
         * Gets help context
         * @param aContext Context to be filled with own information
         * @see CCoeControl
         */
        void GetHelpContext( TCoeHelpContext& aContext ) const;


        /**
         * Callback method
         * Get's called when a dialog is dismissed.
         * @see MProgressDialogCallback
         */
        void DialogDismissedL( TInt aButtonId );

        /**
         * From CCoeControl.
         * Handle focus event change.
         * @see CCoeControl
         */
        void FocusChanged( TDrawNow aDrawNow );

    private:
        /**
         * Constructor
         * @param aAppUi: Reference to the appui instance
         * @param aViewSwitcher This is used to switch views.
         * @param aRecordedChatsArray: Array of listed items
         * @param aContextFlag : flag for context sensitive options
         */
        CCARecordedChatsListViewContainer( MCARecipientObserver& aMenuObserver, CCAAppUi& aAppUi,
                                           MCAViewSwitcher& aViewSwitcher,
                                           CCARecordedChatsArray& aRecordedChatsArray,
                                           TBool& aContextFlag );

    private: // data

        // Owns. Listbox used for chat-list
        CAknDoubleGraphicStyleListBox* iListBox;

        // Doesn't own. Array of group data
        CCARecordedChatsArray& iRecordedChatsArray;

        // Doesn't own
        CCAAppUi& iAppUi;

        // Doesn't own. Handle to view switcher
        MCAViewSwitcher& iViewSwitcher;

        // owns For delete progression
        CIdle* iIdle;

        // Owns Progress dialog for delete chats.
        CAknProgressDialog* iProgressDialog;

        // Owns Progress info
        CEikProgressInfo* iProgressInfo;

        // Progress count for deletion progress bar
        const TInt& iProgressCount;

        /**
         * Context sensitive flag. When this is on,
         * context sensitive menu is shown.
         */
        TBool& iContextFlag;

        /**
         * reference to RecordedChatsPC
         */
        MCARecordedChatsPC& iRecordedChatsPC;

        /**
         * reference to RecipientObserver
         */
        MCARecipientObserver& iMenuObserver;
        
        //Recorded item is moving
        TBool iMovingFlag;

    };

#endif // CCARECORDEDCHATSLISTVIEWCONTAINER_H

// End of File
