/*
* Copyright (c) 2007-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:    
*
*/


#ifndef HNMDBUTTON_H_
#define HNMDBUTTON_H_

#include <e32base.h>

struct THnMdCommonPointers;
class CHnCondition;
class CLiwGenericParamList;
class CGulIcon;
class CHnMdValueImage;
class CHnMdValueText;
class TXmlEngElement;
class CHnConditionInterface;
class CHnAttributeBase;

/**
 * Toolbar button.
 * 
 * This class represents the toolbar button.
 *
 * @lib hnmetadatamodel
 * @since S60 5.0
 * @ingroup group_hnmetadatamodel
 */
NONSHARABLE_CLASS( CHnMdButton ) : public CBase
    {
public:

    /**
     * Two-phase constructor.
     *
     * @since S60 5.0
     * @param aElement Xml element.
     * @param aCmnPtrs Common pointers.
     * @return Constructed object.
     */
    static CHnMdButton* NewLC( TXmlEngElement aElement,
           THnMdCommonPointers* aCmnPtrs );

    /**
     * Standard C++ virtual destructor.
     *    
     * @since S60 5.0
     */
   ~CHnMdButton( );
       
    /**
     * Checks if the button should be added.
     *
     * @since S60 5.0
     * @param aQueryResults Query results in the form of a CLiwGenericParamList.
     * @param aPos Position of the record in the above results.
     * @return True if valid.
     */
    TBool ValidateToAddL( const CLiwGenericParamList& aQueryResults, 
                                            TInt aPos = 0 );
    
    /**
     * Checks if the button should be added.
     *
     * @since S60 5.0
     * @param aQueryResults Query results in the form of a CLiwGenericParamList.
     * @param aPos Position of the record in the above results.
     * @return True if valid.
     */
    TBool ValidateToDimmL( const CLiwGenericParamList& aQueryResults, 
                                            TInt aPos = 0 );
       
    /**
     * Gets the id for event generated by this button.
     *
     * @return Event Id.
     */
    TInt GetEventId() const;
       
    /**
     * Gets the index of button.
     *
     * @return Index.
     */
    TInt GetIndex() const;
       
    /**
     * Evaluates button text.
     *
     * @param aQueryResults Results from service.
     * @param aPos Position of item, needed for parsing the path to query.
     * @return Button text
     */
    const TPtrC EvaluateButtonTextL( 
           const CLiwGenericParamList& aQueryResults, TInt aPos = 0 );
       
    /**
     * Evaluates and returns an icon for the button.
     *
     * @param aQueriesResultsList Results from service.
     * @param aPos Position of item.
     * @return bit map
     */
//    CGulIcon* EvaluateIconL( const CLiwGenericParamList& aQueriesResultsList, 
//                                                           TInt aPos ) const;
    CHnAttributeBase* EvaluateIconL( const CLiwGenericParamList& aQueriesResultsList, 
            TInt aPos ) const;
private:
    /**
     * Standard C++ constructor.
     *
     * @since S60 5.0
     */
    CHnMdButton();

    /**
     * Standard symbian 2nd pahse constructor.
     *
     * @since S60 5.0
     * @param aElement Xml element.
     * @param aCmnPtrs Common pointers.
     */
    void ConstructL( TXmlEngElement aElement,
            THnMdCommonPointers* aCmnPtrs );

private: // data

    /**
     * Own - Help text string handler.
     */
    CHnMdValueText* iButtonText;

    /**
     * Index.
     */
    TInt iIndex;

    /**
     * Event element.
     */
    TInt iEventId;
  
    /**
     * Own - Condition - if passed, button is added to toolbar.
     */
    CHnConditionInterface* iConditionAdd;
    
    /**
     * Own - Condition - if passed, button is dimmed.
     */
    CHnConditionInterface* iConditionDimm;
    
    /**
     * Own - Keeps icon for button.
     */
    CHnMdValueImage* iIcon;
    
    };

#endif // HNMDBUTTON_H_
