/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.ui;

import com.nokia.tools.themeinstaller.installationmanager.IInstallationListener;
import com.nokia.tools.themeinstaller.installationmanager.InstallationManager;
import com.nokia.tools.themeinstaller.installationmanager.InstallationParameters;
import com.nokia.tools.themeinstaller.installationmanager.Lock;
import com.nokia.tools.themeinstaller.installationmanager.ProgressEvent;
import com.nokia.tools.themeinstaller.logger.LogWriter;
import java.io.File;
import java.io.IOException;

public class ThemeInstaller {
    private static final String ERROR_PREFIX = "*** ERROR: ";
    private static final String USAGE = "\nUSAGE: ThemeInstaller manifest_file [destination_dir] [-option_1] [-option_n]\n\nOptions:\n    -loc:<loc_settings_filename.xml>   Enable localisation enhancements\n    -prop:<properties_filename.prop>   Use external properties file instead of the default one\n    -log:<path>                        Path for log file\n    -log                               If no path given, the log is printed to console\n";
    private static final String OPTION_PREFIX = "-";
    private static final String LOC_OPTION = "loc:";
    private static final String PROP_OPTION = "prop:";
    private static final String LOG_PATH_OPTION = "log:";
    private static final String LOG_PATH_OPTION_NO_PATH = "log";
    private Lock iLock = new Lock();
    protected String iManifest;
    protected String iDestination;
    protected String iLocSettings;
    protected String iPropertiesFile;
    protected String iLogDir;

    public static void main(String[] aArgs) {
        ThemeInstaller instance = new ThemeInstaller();
        instance.install(aArgs);
    }

    protected ThemeInstaller() {
    }

    protected void install(String[] aArgs) {
        try {
            this.parseArgs(aArgs);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(ERROR_PREFIX + iae.getMessage());
            System.out.println(USAGE);
            return;
        }
        catch (IOException e) {
            System.out.println(ERROR_PREFIX + e.getMessage());
        }
        try {
            try {
                this.doInstall();
            }
            catch (Exception e) {
                String error = "*** ERROR: Installation failed: " + e.getMessage();
                if (!LogWriter.getInstance().inConsoleMode()) {
                    System.out.println(error);
                }
                LogWriter.getInstance().logSevere(error);
                LogWriter.closeInstance();
            }
        }
        finally {
            LogWriter.closeInstance();
        }
    }

    protected void doInstall() throws Exception {
        InstallationParameters params = new InstallationParameters(new File(this.iManifest), new File(this.iDestination));
        LogWriter.getInstance().logInfo("Starting Installer");
        LogWriter.getInstance().logInfo("Manifest file : " + this.iManifest);
        LogWriter.getInstance().logInfo("Destination directory : " + this.iDestination);
        if (this.iLocSettings != null) {
            params.setLocSettings(new File(this.iLocSettings));
            LogWriter.getInstance().logInfo("Settings file : " + params.getLocSettings().getPath());
        }
        if (this.iPropertiesFile != null) {
            params.setPropFile(new File(this.iPropertiesFile));
            LogWriter.getInstance().logInfo("Properties file : " + params.getPropFile().getPath());
        }
        IInstallationListener listener = new IInstallationListener(){

            public void installationCompleted(ProgressEvent aEvent) {
                if (aEvent.getError() == 0) {
                    if (!LogWriter.getInstance().inConsoleMode()) {
                        System.out.println("Installation done.");
                    }
                    LogWriter.getInstance().logInfo("Installation done");
                } else {
                    String error = "*** ERROR: Installation failed, error: " + aEvent.getError() + ", " + aEvent.getMessage();
                    if (!LogWriter.getInstance().inConsoleMode()) {
                        System.out.println(error);
                    }
                    LogWriter.getInstance().logSevere(error);
                }
                ThemeInstaller.this.iLock.unLock();
            }

            public void installationProgress(ProgressEvent aEvent) {
                if (aEvent.getState() == 1) {
                    String message = "Resource files parsing done, error: " + aEvent.getError() + ", theme: " + aEvent.getName() + ", language: " + aEvent.getLanguage();
                    if (!LogWriter.getInstance().inConsoleMode()) {
                        System.out.println(message);
                    }
                    LogWriter.getInstance().logInfo(message);
                } else if (aEvent.getState() == 2) {
                    String message = "Installed ODT: " + aEvent.getFileName();
                    if (!LogWriter.getInstance().inConsoleMode()) {
                        System.out.println(message);
                    }
                    LogWriter.getInstance().logInfo(message);
                }
            }
        };
        InstallationManager i = new InstallationManager(params, listener);
        i.startInstallation();
        this.iLock.lock();
    }

    protected void parseArgs(String[] aArgs) throws IllegalArgumentException, IOException {
        if (aArgs.length == 0) {
            throw new IllegalArgumentException("No command line arguments");
        }
        this.iManifest = aArgs[0];
        this.iDestination = aArgs.length > 1 && !aArgs[1].startsWith(OPTION_PREFIX) ? aArgs[1] : System.getProperty("user.dir");
        int i = 1;
        while (i < aArgs.length) {
            String opt = "-loc:";
            if (aArgs[i].startsWith(opt)) {
                this.iLocSettings = aArgs[i].substring(opt.length());
                if (this.iLocSettings.length() == 0) {
                    throw new IllegalArgumentException("No localisation settings file defined with the option");
                }
            }
            if (aArgs[i].startsWith(opt = "-prop:")) {
                this.iPropertiesFile = aArgs[i].substring(opt.length());
                if (this.iPropertiesFile.length() == 0) {
                    throw new IllegalArgumentException("No external properties file name defined with the option");
                }
            }
            if (aArgs[i].equals(opt = "-log")) {
                LogWriter.initialize(null);
            }
            if (aArgs[i].startsWith(opt = "-log:")) {
                this.iLogDir = aArgs[i].substring(opt.length());
                if (this.iLogDir.length() == 0) {
                    LogWriter.initialize(null);
                } else {
                    LogWriter.initialize(new File(this.iLogDir));
                }
            }
            ++i;
        }
    }
}

