/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.gui;

import com.sardak.antform.gui.CalendarDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DateChooser
extends JPanel
implements ActionListener {
    private SimpleDateFormat formatter;
    private Date date = new Date();
    private JFormattedTextField textField;
    private JButton button;

    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setTooltipText(String tooltip) {
        super.setToolTipText(tooltip);
        this.button.setToolTipText(tooltip);
        this.textField.setToolTipText(tooltip);
    }

    public DateChooser(String format) {
        this.textField = new JFormattedTextField(new SimpleDateFormat(format));
        this.button = new JButton("...");
        this.button.addActionListener(this);
        this.button.setPreferredSize(new Dimension(this.button.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.button, "East");
        this.formatter = new SimpleDateFormat(format);
        this.textField.setText(this.formatter.format(this.date));
    }

    public void setBorder(Border border) {
        if (this.textField != null) {
            this.textField.setBorder(border);
        }
    }

    public void setBackground(Color bg) {
        if (this.textField != null) {
            this.textField.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    public Font getFont() {
        return this.textField == null ? null : this.textField.getFont();
    }

    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            Date newDate = new Date();
            try {
                newDate = this.formatter.parse(this.textField.getText());
            }
            catch (ParseException pe) {
                // empty catch block
            }
            CalendarDialog dialog = new CalendarDialog(JOptionPane.getRootFrame());
            dialog.setDate(newDate);
            dialog.setLocation(this.button.getLocationOnScreen());
            dialog.show();
            this.textField.setText(this.formatter.format(dialog.getDate()));
        }
    }

    public void setText(String text) {
        try {
            Date date;
            if (text == null) {
                text = this.formatter.format(new Date());
            }
            if ((date = this.formatter.parse(text)) != null) {
                this.textField.setText(text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        frame.getContentPane().add((Component)new DateChooser("dd/MM/yyyy"), "Center");
        SpinnerDateModel model = new SpinnerDateModel(new Date(), null, null, 5);
        JSpinner spinner = new JSpinner(model);
        frame.getContentPane().add((Component)spinner, "South");
        frame.show();
        frame.pack();
        frame.setDefaultCloseOperation(3);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }
}

