/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.Node;

public class CheckScriptDefStyle
extends AbstractCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("scriptdef")) {
            String scriptdefname = node.attributeValue("name");
            this.checkScriptDefStyle(scriptdefname, (Node)node);
        }
    }

    public void checkScriptDefStyle(String name, Node node) {
        List statements = node.selectNodes("//scriptdef[@name='" + name + "']/attribute");
        Pattern p1 = Pattern.compile("attributes.get\\([\"']([^\"']*)[\"']\\)");
        Matcher m1 = p1.matcher(node.getText());
        ArrayList<String> props = new ArrayList<String>();
        while (m1.find()) {
            props.add(m1.group(1));
        }
        ArrayList<String> attributes = new ArrayList<String>();
        for (Node statement : statements) {
            attributes.add(statement.valueOf("@name"));
        }
        if (!statements.isEmpty() && props.isEmpty()) {
            this.log("Scriptdef " + name + " doesn't reference attributes directly, poor style");
        }
    }
}

