/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:30 $
 * $Revision: 1.14 $
 */

#ifndef _MSL_FLOAT_WIN32_H
#define _MSL_FLOAT_WIN32_H

/*
 *	The routines and definitions in this file are intended for source-level
 *	compatibility with the respective definitions in MSVC.  The binary values
 *	for the macros, however, are different to allow a simpler implementation.
 *	Do not rely on the specific values of any of the macros.
 */


_MSL_BEGIN_EXTERN_C	

_MSL_IMP_EXP_C void _MSL_CDECL _fpreset(void) _MSL_CANT_THROW;
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _control87(unsigned int __mask, unsigned int __how) _MSL_CANT_THROW;
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _status87(void) _MSL_CANT_THROW;
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _clear87(void) _MSL_CANT_THROW;

_MSL_IMP_EXP_C unsigned int _MSL_CDECL _controlfp(unsigned int __mask, unsigned int __how) _MSL_CANT_THROW;
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _statusfp(void) _MSL_CANT_THROW;
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _clearfp(void) _MSL_CANT_THROW;

_MSL_END_EXTERN_C	

/*	__how parameters for _controlfp() and __control87 */
#define _MCW_IC			(1U << 12)	/* infinity control */
#define _MCW_PC			(3U << 8)	/* precision control */
#define _MCW_RC			(3U << 10)	/* rounding control */
#define _MCW_EM			0x001fU		/* exception mask */
#define _MCW_DN			0U			/* denormal control (unsupported on x86) */

/*	__mask parameters for __controlfp() and __control87() */

/*	_MCW_DN	 	-- denormal control (not supported on x86) */
#define _DN_SAVE						0U
#define _DN_FLUSH						0U
#define _DN_FLUSH_OPERANDS_SAVE_RESULTS	0U
#define _DN_SAVE_OPERANDS_FLUSH_RESULTS	0U

/*	_MCW_IC		-- infinity control */
#define _IC_AFFINE						(1U << 12)
#define _IC_PROJECTIVE					(0U << 12)

/*	_MCW_PC		-- precision control */
#define _PC_64							(3U << 8)
#define _PC_53							(2U << 8)
#define _PC_24							(0U << 8)

/*	_MCW_RC		-- rounding control */
#define _RC_NEAR						(0U << 10)	/* round to nearest */
#define _RC_DOWN						(1U << 10)	/* round down */
#define _RC_UP							(2U << 10)	/* round up */
#define _RC_CHOP						(3U << 10)	/* truncate */

/*	_MCW_EM		-- exception mask bits */
#define _EM_INEXACT						(1U << 5)
#define _EM_UNDERFLOW					(1U << 4)
#define _EM_OVERFLOW					(1U << 3)
#define _EM_ZERODIVIDE					(1U << 2)
#define _EM_DENORMAL					(1U << 1)
#define _EM_INVALID						(1U << 0)

/*	default control word */
#define _CW_DEFAULT ( _RC_NEAR | _PC_64 | _EM_INVALID | _EM_ZERODIVIDE | _EM_OVERFLOW | _EM_UNDERFLOW | _EM_INEXACT | _EM_DENORMAL)

/*	__statusfp/__status87 FP status word bits */
#define _SW_INEXACT						(1U << 5)
#define _SW_UNDERFLOW					(1U << 4)
#define _SW_OVERFLOW					(1U << 3)
#define _SW_ZERODIVIDE					(1U << 2)
#define _SW_DENORMAL					(1U << 1)
#define _SW_INVALID						(1U << 0)

/*	x87-specific, top of FP stack */
#define _SW_TOP							(7U << 11)

/*	may be set when _SW_INVALID is set */
#define _SW_STACKUNDERFLOW				(1U << 31)
#define _SW_STACKOVERFLOW				(1U << 30)
#define _SW_SQRTNEG						0U			/* not detected */
#define _SW_UNEMULATED					0U			/* not detected */

_MSL_BEGIN_EXTERN_C	

_MSL_IMP_EXP_C unsigned int _MSL_CDECL _control87(unsigned int, unsigned int) _MSL_CANT_THROW;
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _controlfp(unsigned int, unsigned int) _MSL_CANT_THROW; 
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _status87(void) _MSL_CANT_THROW;
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _statusfp(void) _MSL_CANT_THROW;
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _clear87(void) _MSL_CANT_THROW;	
_MSL_IMP_EXP_C unsigned int _MSL_CDECL _clearfp(void) _MSL_CANT_THROW;

_MSL_END_EXTERN_C	

#if _MSL_USE_INLINE

/*	read/write FPU control word */
_MSL_INLINE unsigned int _MSL_CDECL _control87(unsigned int __mask, unsigned int __how) _MSL_CANT_THROW
{
	unsigned short cw;
	__asm
	{
		fnstcw	cw						; get current control word
		mov		ax, word ptr __how
		and		word ptr __mask, ax		; remove stray bits from __mask
		not		ax						; get mask for legal bits
		and		cw, ax					; remove bits we may set from __mask
		mov		ax, word ptr __mask
		or		cw, ax					; apply changes
		fldcw	cw						; store new control word
		fnstcw	cw						; get the bits that were actually set
	}
	return cw;
}

_MSL_INLINE unsigned int _MSL_CDECL _controlfp(unsigned int __mask, unsigned int __how) _MSL_CANT_THROW
{
	return _control87(__mask, __how);
}

/*	reset FPU */

_MSL_INLINE void _MSL_CDECL _fpreset(void) _MSL_CANT_THROW
{
	unsigned short cw = _CW_DEFAULT;
	
	__asm
	{
		fninit
		fldcw	cw
	}
}

/*	get FPU status word */
_MSL_INLINE unsigned int _MSL_CDECL _status87(void) _MSL_CANT_THROW
{
	unsigned int ret = 0;

	__asm fnstsw	word ptr ret
	
	/* stack fault bit mapped into more specific conditions */
	if (ret & 0x40U)
	{
		ret &= ~0x40U;
		ret |= _SW_INVALID;
		
		/* if anything is on the stack, assume it was an overflow */
		if (ret & _SW_TOP)
			ret |= _SW_STACKOVERFLOW;
		else
			ret |= _SW_STACKUNDERFLOW;
	}

	return ret;
}

_MSL_INLINE unsigned int _MSL_CDECL _statusfp(void) _MSL_CANT_THROW
{
	return _status87();
}

/*	clear FPU status flags */
_MSL_INLINE unsigned int _MSL_CDECL _clear87(void) _MSL_CANT_THROW
{
	char env[28];
	unsigned int ret;
	__asm																/*- cc 010622 -*/
	{
		fnstenv	env
		movzx	eax, word ptr [env+4]
		mov		ret, eax
		and		word ptr [env+4], ~0x1f	; reset exception bits in status word at [env+4]
		fldenv	env
	}
	return ret;
}

_MSL_INLINE unsigned int _MSL_CDECL _clearfp(void) _MSL_CANT_THROW
{
	return _clear87();
}

#endif /* #if _MSL_USE_INLINE */

#endif /* _MSL_FLOAT_WIN32_H */

/* Change record:
 * ejs 010531 Created.
 * cc  010622 Added ejs's fixes - made inline to __inline, asm to __asm
 * ejs 010718 Reorganized to supply proper declarations and allow for library linking
 * cc  011203 Added _MSL_CDECL for new name mangling 
 * hh  020603 Added no throw spec to functions
 */