/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:29 $
 * $Revision: 1.12 $
 */

#ifndef __MSL_DEFAULTLIBS_WIN32_H_
#define __MSL_DEFAULTLIBS_WIN32_H_

#if __MWERKS__ >= 0x3000

 	#include <ansi_prefix.Win32.h>

	#if _MSL_CALLINGCONV == _MSL_CALLINGCONV_CDECL
		#ifndef _DLL
			#if !_MSL_THREADSAFE
				/* static single-thread */
				#ifndef _DEBUG
					#pragma comment(lib, "MSL_All_ST")
				#else
					#pragma comment(lib, "MSL_All_ST_D")
				#endif
				#if _WINSIOUX || __option(microsoft_exceptions)
					#error /* no MSL library is built for this configuration */
				#endif
			#else
				#if !__option(microsoft_exceptions) && !_WINSIOUX
					/* static multi-thread */
					#ifndef _DEBUG
						#pragma comment(lib, "MSL_All_x86")
					#else
						#pragma comment(lib, "MSL_All_x86_D")
					#endif
				#elif __option(microsoft_exceptions)
					/* static multi-thread MS exceptions */
					#ifndef _DEBUG
						#pragma comment(lib, "MSL_All_MSE")
					#else
						#pragma comment(lib, "MSL_All_MSE_D")
					#endif
				#else /* _WINSIOUX */
					/* static multi-thread WinSIOUX */
					#ifndef _DEBUG
						#pragma comment(lib, "MSL_Runtime_x86")
						#pragma comment(lib, "MSL_C_WINSIOUX")
						#pragma comment(lib, "MSL_C++_x86")
						#pragma comment(lib, "MSL_Extras_WINSIOUX")
					#else
						#pragma comment(lib, "MSL_Runtime_x86_D")
						#pragma comment(lib, "MSL_C_WINSIOUX_D")
						#pragma comment(lib, "MSL_C++_x86_D")
						#pragma comment(lib, "MSL_Extras_WINSIOUX_D")
					#endif
					#pragma comment(lib, "comdlg32,winspool")
				#endif
			#endif
		#else	/* _DLL */
			/* shared multi-thread */
			#if !__option(microsoft_exceptions)
				#ifndef _DEBUG
					#pragma comment(lib, "MSL_All-DLL_x86")
				#else
					#pragma comment(lib, "MSL_All-DLL_x86_D")
				#endif
			#else
				#ifndef _DEBUG
					#pragma comment(lib, "MSL_All-DLL_MSE")
				#else
					#pragma comment(lib, "MSL_All-DLL_MSE_D")
				#endif
			#endif
			#if _WINSIOUX
				#error /* no MSL library is built for this configuration */
			#endif
		#endif /*_DLL*/
	#elif _MSL_CALLINGCONV == _MSL_CALLINGCONV_3DCALL
		#ifndef _DLL
			/* static multi-thread */
			#ifndef _DEBUG
				#pragma comment(lib, "MSL_All_3DNow")
			#else
				#pragma comment(lib, "MSL_All_3DNow_D")
			#endif
		#else	/* _DLL */
			/* shared multi-thread */
			#ifndef _DEBUG
				#pragma comment(lib, "MSL_All-DLL_3DNow")
			#else
				#pragma comment(lib, "MSL_All-DLL_3DNow_D")
			#endif
		#endif /*_DLL*/
		#if _WINSIOUX || __option(microsoft_exceptions) || !_MSL_THREADSAFE
			#error /* no MSL library is built for this configuration */
		#endif
	#else /* other multimedia calling convention? */
		#error /* no MSL library is built for this configuration */
	#endif 	/* #if _MSL_CALLINGCONV */

	/* default Win32 SDK libs */
	#pragma comment(lib, "gdi32")
	#pragma comment(lib, "kernel32")
	#pragma comment(lib, "user32")

#endif /*__MWERKS__*/

#endif /*__MSL_DEFAULTLIBS_WIN32_H_*/

/* Change record:
 * 020206 EJS Created
 * 020322 EJS Cleaned up along with ansi_prefix.win32.h to allow more combos to work
 * 020406 EJS Use separate #pragmas per library to be MS-compatible
 * 020416 EJS Force ansi_prefix.win32.h so we're sure to have macros defined
 * 030717 EJS Do not allow compilation with incorrect default libraries (rather than generating a warning)
 * 040109 EJS Use MSL_All libraries when available
 */
