/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionListenerComponent;
import com.sardak.antform.types.DummyListProperty;
import com.sardak.antform.util.CSVReader;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import org.apache.tools.ant.Task;

public class ListProperty
extends DummyListProperty
implements ActionListenerComponent {
    private String values;
    private String separator = ",";
    private String escapeSequence = "\\";
    private SpinnerListModel model;
    private JSpinner spinner;

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getValues() {
        return this.values;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public String getEscapeSequence() {
        return this.escapeSequence;
    }

    public void setEscapeSequence(String escapeSequence) {
        this.escapeSequence = escapeSequence;
    }

    public List asList() {
        return new CSVReader(this.separator, this.escapeSequence).digest(this.values, true);
    }

    public void addToControlPanel(ControlPanel panel) {
        this.model = new SpinnerListModel(this.asList());
        this.spinner = new JSpinner(this.model);
        panel.getStylesheetHandler().addSpinner(this.spinner);
        this.spinner.setEnabled(this.isEditable());
        this.initComponent(this.spinner, panel);
    }

    public boolean validate(Task task) {
        boolean isValid = super.validate(task, "ListProperty");
        if (this.getValues() == null) {
            task.log("ListProperty : attribute \"values\" missing.");
            isValid = false;
        } else if (this.getValues().length() == 0) {
            task.log("ListProperty : attribute \"values\" is empty.");
            isValid = false;
        }
        return isValid;
    }

    public void ok() {
        this.getProject().setProperty(this.getProperty(), this.spinner.getValue().toString());
    }

    public void reset() {
        if (this.model.getList().contains(this.getCurrentProjectPropertyValue())) {
            this.spinner.setValue(this.getCurrentProjectPropertyValue());
        } else {
            this.spinner.setValue(this.model.getList().get(0));
        }
    }

    public JComponent getFocusableComponent() {
        return this.spinner;
    }
}

