# This script builds all the Symbian and Win32 runtime libraries in one fell swoop.
# The individual libraries are not created.

STATICWINCOMBOS=\
	MSL_All_Static_x86_Debug MSL_All_Static_x86_Release \
	MSL_All_Static_MSE_Debug MSL_All_Static_MSE_Release \

STATICSYMCOMBOS=\
	MSL_All_Static_x86_Symbian_Debug MSL_All_Static_x86_Symbian_Release \
	MSL_All_Static_MSE_Symbian_Debug MSL_All_Static_MSE_Symbian_Release \
	Cover_Symbian_error
	
DLLWINCOMBOS=\
	MSL_All_Dll_x86_Debug MSL_All_Dll_x86_Release \
	MSL_All_Dll_MSE_Debug MSL_All_Dll_MSE_Release

DLLSYMCOMBOS=\
	MSL_All_Dll_x86_Symbian_Debug MSL_All_Dll_x86_Symbian_Release \
	MSL_All_Dll_MSE_Symbian_Debug MSL_All_Dll_MSE_Symbian_Release
	
all: $(STATICWINCOMBOS) $(STATICSYMCOMBOS) $(DLLWINCOMBOS) $(DLLSYMCOMBOS)

# the product used to ship windows too...
symbianproduct: $(STATICSYMCOMBOS) $(STATICWINCOMBOS)

symbian: $(STATICSYMCOMBOS)

windows: $(STATICWINCOMBOS) $(DLLWINCOMBOS)

ifdef DEBUG
CCWIN=nmwcc
LDWIN=nmwld
CCSYM=nmwccsym2
LDSYM=nmwldsym2
else
CCWIN=mwcc
LDWIN=mwld
CCSYM=mwccsym2
LDSYM=mwldsym2
endif

ifndef BINDIR
BINDIR=
endif
DLLVER=90
SYMDLLVER=32

ifdef IN_CVS
TOP=../../../..
MSL=$(TOP)/msl
W32=$(TOP)/win32_x86_support/Win32-x86_Support
RT=$(TOP)/Runtime
	ifdef OUT_CW
	OUTLIBS=$(CWDIR)/Win32-x86 Support/Libraries/Runtime/Libs
	else
	OUTLIBS=$(RT)/Runtime_x86/Runtime_Win32/Libs
	endif
	DLLS=$(OUTLIBS)/MSL_All-Dlls
else
	ifdef OLD_LAYOUT
	TOP=../../../../../..
	MSL=$(TOP)/MSL
	W32=$(TOP)/Win32-x86 Support
	RT=$(W32)/Libraries/Runtime
	OUTLIBS=$(W32)/Libraries/Runtime/Libs
	DLLS=$(OUTLIBS)/MSL_All-Dlls
	else
	TOP=../../../..
	MSL=$(TOP)/MSL
	W32=$(TOP)/Win32-x86 Support
	RT=$(TOP)/Runtime
	OUTLIBS=$(RT)/Runtime_x86/Runtime_Win32/Libs
	# Symbian tools wants a shorter %PATH% to avoid Win32 limit of 1023
	# give an option to choose directory if we want
	DLLS=$(OUTLIBS)/MSL_All-Dlls
	endif	
endif

RTCOMMON=$(RT)/(Runtime_Common)
RTCOMMONMW=$(RT)/(Runtime_Common)/MWRuntime
RTX86=$(RT)/Runtime_x86/(Common_Source)
RTWIN32=$(RT)/Runtime_x86/Runtime_Win32/(Source)

LIBS=$(OUTLIBS)

# NB: -ext .obj used so C and CPP files with the same basename have unique outputs
CFLAGS=-ext .obj \
	 -iso_templates on -Cpp_exceptions on -rtti on -bool on -wchar_t on \
	-trigraphs on -lang c99 -str reuse \
	-pragma "avoid_ebp on" \
	-nodefaultlibs \
	-maxerrors 4 -warnings on,nounusedarg 
	
LDFLAGS=-nostdlib -nodefaultlibs
LDFLAGS_DLL=-export pragma

RELFLAGS=-O4,p -inline smart,bottomup
DBGFLAGS=-g -O0 -inline off

INCS=-nostdinc -I. -I- \
	"-I$(RTWIN32)" "-I$(RTX86)" "-I$(RTCOMMON)" "-I$(RTCOMMONMW)" \
	-ir "$(MSL)/MSL_C/MSL_Common" \
	-ir "$(MSL)/MSL_C/MSL_Win32" \
	-ir "$(MSL)/MSL_C/MSL_X86" \
	-ir "$(MSL)/MSL_C++/MSL_Common" \
	-ir "$(MSL)/MSL_C++/MSL_Win32" \
	-ir "$(MSL)/MSL_Extras/MSL_Common" \
	-ir "$(MSL)/MSL_Extras/MSL_Win32" \
	-ir "$(W32)/Headers"

# only in a "DLL" target of a DLL build, or generally in a static lib
DLLSRCS= \
	"$(MSL)/MSL_C/MSL_Common/Src/alloc.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/ansi_files.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/arith.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/bsearch.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/buffer_io.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/char_io.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/ctype.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/direct_io.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/errno.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/file_io.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/file_pos.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/float.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/locale.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/mbstring.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/mem.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/mem_funcs.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/misc_io.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/pool_alloc.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/printf.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/qsort.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/rand.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/scanf.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/signal.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/string.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/strtold.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/strtoul.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/time.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wchar_io.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wcstold.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wcstoul.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wctrans.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wctype.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wfile_io.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wmem.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wprintf.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wscanf.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wstring.c" \
	"$(MSL)/MSL_C/MSL_Common/Src/wtime.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/assert.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/critical_regions.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/file_io.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/FINDFILE.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/pool_alloc.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/signal.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/startup.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/sysenv.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/Thread.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/ThreadLocalData.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/time.win32.c" \
	"$(MSL)/MSL_C/MSL_Win32/Src/wsysenv.win32.c" \
	"$(MSL)/MSL_C/MSL_X86/ansifp_x86.c" \
	"$(MSL)/MSL_C/MSL_X86/fenv_x87.c" \
	"$(MSL)/MSL_C/MSL_X86/math_x87.c" \
	"$(MSL)/MSL_C/MSL_X86/setjmp.x86.c" \
	"$(MSL)/MSL_C++/MSL_Common/Src/complex.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/ios.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/iostream.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/locale.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/MSLstring.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/msl_condition.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/msl_mutex.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/msl_thread.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/msl_time.cpp" \
	"$(MSL)/MSL_C++/MSL_Common/Src/strstream.cpp" \
	"$(MSL)/MSL_Extras/MSL_Common/Src/extras.c" \
	"$(MSL)/MSL_Extras/MSL_Common/Src/old_posix.c" \
	"$(MSL)/MSL_Extras/MSL_Common/Src/stat.c" \
	"$(MSL)/MSL_Extras/MSL_Common/Src/stdio_posix.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/conio.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/dirent.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/extras.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/fcntl.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/float.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/stat.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/stdio_posix.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/unistd.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/utime.win32.c" \
	"$(MSL)/MSL_Extras/MSL_Win32/Src/utsname.win32.c" \
	"$(RTWIN32)/arrcondes.cpp" \
	"$(RTX86)/ExceptionX86.cpp" \
	"$(RTWIN32)/excrtl.cpp" \
	"$(RTWIN32)/mwcrtdllmain.c" \
	"$(RTCOMMONMW)/MWRTTI.cpp" \
	"$(RTCOMMON)/New.cpp" \
	"$(RTX86)/NMWExceptionX86.cpp" \
	"$(RTWIN32)/noexport.c" \
	"$(RTWIN32)/runinit.c" \
	"$(RTWIN32)/setupargs.c" \
	"$(RTWIN32)/wmwcrtdllmain.c" \
	"$(RTWIN32)/wsetupargs.c" \

# only in a "Lib" target of a DLL build, or generally in a static lib
LIBSRCS=\
	"$(RTWIN32)/maincrt.c" \
	"$(RTWIN32)/wmaincrt.c" \
	"$(RTWIN32)/dllmaincrt.c" \
	"$(RTWIN32)/wdllmaincrt.c" \
	"$(RTWIN32)/winmaincrt.c" \
	"$(RTWIN32)/wwinmaincrt.c"

BUILT_OBJS=\
	"$(RTWIN32)/ccinit.obj" \
	"$(RTWIN32)/cexc.obj" \
	"$(RTWIN32)/ctls.obj" 

# in both the "Dll" and "Lib" target of a DLL build, and in a static lib
SHAREDSRCS=\
	"$(RTWIN32)/dummydllmain.c" \
	"$(RTWIN32)/cpprtl.c" \
	"$(RTWIN32)/globdest.c" \
	"$(RTWIN32)/virtual.cpp" \
	"$(RTWIN32)/compiler_math.c" \
	"$(RTWIN32)/LongLongx86.c" \
	"$(RTWIN32)/stackall.c" \
	"$(RTWIN32)/DestroyX86.cpp" \
	"$(MSL)/MSL_C/MSL_Win32/Src/abort_exit_win32.c" \
	"$(RTWIN32)/onetimeinit.cpp" \
	"$(RTWIN32)/mathcompat.c" \
	"$(RTWIN32)/msruntimecompat.c" \
	"$(RTWIN32)/exchand.cpp" \
	$(BUILT_OBJS)
	
ALLSRCS=$(DLLSRCS) $(LIBSRCS) $(SHAREDSRCS)

W32LIBS=-L"$(W32)/Libraries/Win32 SDK"

setup: 
	$(BINDIR)mkdir -p "$(LIBS)" "$(DLLS)"
	
clean:
	$(BINDIR)rm -f "$(LIBS)"/*.lib "$(DLLS)"/*.dll "$(DLLS)"/*.lib

STATIC_LIB_BUILD=$(CFLAGS) $(INCS) -library $(ALLSRCS)

DLL_MAIN_BUILD=$(CFLAGS) $(INCS) -shared \
		-prefix BuildDllPrefix.h \
		-f MSL_Complete.def \
		$(LDFLAGS) $(LDFLAGS_DLL) \
		$(W32LIBS) \
		-lamd_sp_mathlib_dll.lib \
		-ladvapi32.lib -luser32.lib -lkernel32.lib \
		$(DLLSRCS) $(SHAREDSRCS) 
		
DLL_LIB_BUILD=$(CFLAGS) $(INCS) -library \
		-prefix BuildingHelperLib.h \
		$(LDFLAGS) \
		$(LIBSRCS) $(SHAREDSRCS)
	
test:
	$(CCWIN) $(CFLAGS) $(INCS) $(DBGFLAGS) -exc mw $(USERFLAGS) "$(USERFILE)"
	
MSL_All_Static_x86_Debug: setup
	$(CCWIN) $(STATIC_LIB_BUILD) $(DBGFLAGS) -exc mw \
		-o "$(LIBS)"/MSL_All_x86_D.lib -linkername $(LDWIN)
	
MSL_All_Static_x86_Release: setup
	$(CCWIN) $(STATIC_LIB_BUILD) $(RELFLAGS) -exc mw \
		-o "$(LIBS)"/MSL_All_x86.lib -linkername $(LDWIN)
		
MSL_All_Static_x86_Symbian_Debug: setup
	$(CCSYM) $(STATIC_LIB_BUILD) $(DBGFLAGS) -exc mw \
		-o "$(LIBS)"/MSL_All_x86_Symbian_D.lib -linkername $(LDSYM)
	
MSL_All_Static_x86_Symbian_Release: setup
	$(CCSYM) $(STATIC_LIB_BUILD) $(RELFLAGS) -exc mw \
		-o "$(LIBS)"/MSL_All_x86_Symbian.lib -linkername $(LDSYM)
		
MSL_All_Static_MSE_Debug: setup
	$(CCWIN) $(STATIC_LIB_BUILD) $(DBGFLAGS) -exc ms \
		-o "$(LIBS)"/MSL_All_MSE_D.lib -linkername $(LDWIN)
	
MSL_All_Static_MSE_Release: setup
	$(CCWIN) $(STATIC_LIB_BUILD) $(RELFLAGS) -exc ms \
		-o "$(LIBS)"/MSL_All_MSE.lib -linkername $(LDWIN)
		
MSL_All_Static_MSE_Symbian_Debug: setup
	$(CCSYM) $(STATIC_LIB_BUILD) $(DBGFLAGS) -exc ms \
		-o "$(LIBS)"/MSL_All_MSE_Symbian_D.lib -linkername $(LDSYM)

# Symbian introduce this bug in epoc32/tools/codewarrior.pm
# make that bug compatible
Cover_Symbian_error : MSL_All_Static_MSE_Symbian_Debug
	cp "$(LIBS)"/MSL_All_MSE_Symbian_D.lib "$(LIBS)"/msl_all_static_mse_symbian_d.lib 
	
MSL_All_Static_MSE_Symbian_Release: setup
	$(CCSYM) $(STATIC_LIB_BUILD) $(RELFLAGS) -exc ms \
		-o "$(LIBS)"/MSL_All_MSE_Symbian.lib -linkername $(LDSYM)
		
MSL_All_Dll_x86_Debug: setup
	$(CCWIN) $(DLL_MAIN_BUILD) $(DBGFLAGS) -exc mw \
		-o "$(DLLS)"/MSL_All-DLL$(DLLVER)_x86_D.dll
	$(CCWIN) $(DLL_LIB_BUILD) $(DBGFLAGS) -exc mw \
		"$(DLLS)"/MSL_All-Dll$(DLLVER)_x86_D.lib \
		-o "$(LIBS)"/MSL_All-DLL_x86_D.lib -linkername $(LDWIN)

MSL_All_Dll_x86_Release: setup
	$(CCWIN) $(DLL_MAIN_BUILD) $(RELFLAGS) -exc mw \
		-o "$(DLLS)"/MSL_All-DLL$(DLLVER)_x86.dll
	$(CCWIN) $(DLL_LIB_BUILD) $(RELFLAGS) -exc mw \
		"$(DLLS)"/MSL_All-Dll$(DLLVER)_x86.lib \
		-o "$(LIBS)"/MSL_All-DLL_x86.lib -linkername $(LDWIN)

MSL_All_Dll_x86_Symbian_Debug: setup
	$(CCSYM) $(DLL_MAIN_BUILD) $(DBGFLAGS) -exc mw \
		-o "$(DLLS)"/MSL_All-DLL$(SYMDLLVER)_x86_Symbian_D.dll
	$(CCSYM) $(DLL_LIB_BUILD) $(DBGFLAGS) -exc mw \
		"$(DLLS)"/MSL_All-DLL$(SYMDLLVER)_x86_Symbian_D.lib \
		-o "$(LIBS)"/MSL_All-DLL_x86_Symbian_D.lib -linkername $(LDSYM)

MSL_All_Dll_x86_Symbian_Release: setup
	$(CCSYM) $(DLL_MAIN_BUILD) $(RELFLAGS) -exc mw \
		-o "$(DLLS)"/MSL_All-DLL$(SYMDLLVER)_x86_Symbian.dll
	$(CCSYM) $(DLL_LIB_BUILD) $(RELFLAGS) -exc mw \
		"$(DLLS)"/MSL_All-DLL$(SYMDLLVER)_x86_Symbian.lib \
		-o "$(LIBS)"/MSL_All-DLL_x86_Symbian.lib -linkername $(LDSYM)

MSL_All_Dll_MSE_Debug: setup
	$(CCWIN) $(DLL_MAIN_BUILD) $(DBGFLAGS) -exc ms \
		-o "$(DLLS)"/MSL_All-DLL$(DLLVER)_MSE_D.dll
	$(CCWIN) $(DLL_LIB_BUILD) $(DBGFLAGS) -exc ms \
		"$(DLLS)"/MSL_All-Dll$(DLLVER)_MSE_D.lib \
		-o "$(LIBS)"/MSL_All-DLL_MSE_D.lib -linkername $(LDWIN)

MSL_All_Dll_MSE_Release: setup
	$(CCWIN) $(DLL_MAIN_BUILD) $(RELFLAGS) -exc ms \
		-o "$(DLLS)"/MSL_All-DLL$(DLLVER)_MSE.dll
	$(CCWIN) $(DLL_LIB_BUILD) $(RELFLAGS) -exc ms \
		"$(DLLS)"/MSL_All-Dll$(DLLVER)_MSE.lib \
		-o "$(LIBS)"/MSL_All-DLL_MSE.lib -linkername $(LDWIN)

MSL_All_Dll_MSE_Symbian_Debug: setup
	$(CCSYM) $(DLL_MAIN_BUILD) $(DBGFLAGS) -exc ms \
		-o "$(DLLS)"/MSL_All-DLL$(SYMDLLVER)_MSE_Symbian_D.dll
	$(CCSYM) $(DLL_LIB_BUILD) $(DBGFLAGS) -exc ms \
		"$(DLLS)"/MSL_All-DLL$(SYMDLLVER)_MSE_Symbian_D.lib \
		-o "$(LIBS)"/MSL_All-DLL_MSE_Symbian_D.lib -linkername $(LDSYM)

MSL_All_Dll_MSE_Symbian_Release: setup
	$(CCSYM) $(DLL_MAIN_BUILD) $(RELFLAGS) -exc ms \
		-o "$(DLLS)"/MSL_All-DLL$(SYMDLLVER)_MSE_Symbian.dll
	$(CCSYM) $(DLL_LIB_BUILD) $(RELFLAGS) -exc ms \
		"$(DLLS)"/MSL_All-DLL$(SYMDLLVER)_MSE_Symbian.lib \
		-o "$(LIBS)"/MSL_All-DLL_MSE_Symbian.lib -linkername $(LDSYM)
