/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:48 $
 * $Revision: 1.3 $
 */
 

#ifndef _MSL_EXTRAS_STDLIB_WIN32_H
#define _MSL_EXTRAS_STDLIB_WIN32_H

#include <ansi_parms.h> 
#include <file_io.h>

_MSL_BEGIN_EXTERN_C

	#define _MAX_DRIVE  3   /* max. length of drive component */
	#define _MAX_DIR    256 /* max. length of path component */
	#define _MAX_EXT    256 /* max. length of extension component */
	#define _MAX_FNAME 256
	#define __max(a,b)  (((a) > (b)) ? (a) : (b))
	#define __min(a,b)  (((a) < (b)) ? (a) : (b))	
	
 	_MSL_IMP_EXP_C  void _MSL_CDECL makepath(char*, const char*, const char*, const char*, const char *) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C  void _MSL_CDECL splitpath (const char *, char *, char *, char *, char *) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C 	int  _MSL_CDECL putenv(const char *) _MSL_CANT_THROW;
	
	_MSL_IMP_EXP_C  void   _MSL_CDECL _makepath(char*, const char*, const char*, const char*, const char *) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C 	void   _MSL_CDECL _splitpath (const char *, char *, char *, char *, char *) _MSL_CANT_THROW;	
	_MSL_IMP_EXP_C 	int    _MSL_CDECL _putenv(const char *) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C 	char * _MSL_CDECL _fullpath(char *, const char *, __std(size_t)) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C 	void   _MSL_CDECL _searchenv(const char *, const char *, char*) _MSL_CANT_THROW;			
	_MSL_IMP_EXP_C 	char * _MSL_CDECL _itoa(int, char *, int) _MSL_CANT_THROW; 
	_MSL_IMP_EXP_C 	char * _MSL_CDECL _ultoa(unsigned long, char *, int) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C char *  _MSL_CDECL _gcvt(double, int, char *) _MSL_CANT_THROW; 
	 
	__inline char* _MSL_CDECL _ltoa(int x, char *y, int z) _MSL_CANT_THROW	{ return (_itoa(x, y, z)); }	
                  
_MSL_END_EXTERN_C

#endif  /* _MSL_EXTRAS_STDLIB_WIN32_H */

/* Change record:
 * cc  030620 Extras split to reduce namespace pollution
 * ejs 030721 Remove <startup.win32.h> include
 * ejs 030721 Move _MAX_xxx macros here from <extras_io.h>
 * cc  030722 Moved underscored functions out of extras common headers/source.  
 *            They now live in the extras_xxxx_win32.h headers/source.
 */