/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ivy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.AbstractResourceResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.Message;

public class ToolResolver
extends AbstractResourceResolver {
    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        Message.verbose((String)"ToolResolver.publish() start");
    }

    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId mrid, String pattern, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        Message.verbose((String)"ToolResolver.findResourceUsingPattern() start");
        Message.verbose((String)artifact.getName());
        Message.verbose((String)mrid.getRevision());
        Message.verbose((String)artifact.getAttribute("versionArgs"));
        String toolVersion = mrid.getRevision();
        ResolvedResource resolvedResource = null;
        try {
            String versionText = this.getToolVersion(artifact);
            Message.verbose((String)versionText);
            if (versionText.contains(toolVersion) || versionText.matches(artifact.getAttribute("versionExp"))) {
                BasicResource resource = new BasicResource(artifact.getName(), true, 0L, 0L, true);
                resolvedResource = new ResolvedResource((Resource)resource, toolVersion);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resolvedResource;
    }

    protected long get(Resource resource, File dest) throws IOException {
        Message.verbose((String)"ToolResolver.get() start");
        return 0L;
    }

    private String getToolVersion(Artifact artifact) throws IOException {
        String toolName = artifact.getName();
        String toolType = artifact.getType();
        String versionArgs = artifact.getAttribute("versionArgs");
        Runtime runtime = Runtime.getRuntime();
        Message.verbose((String)("'" + toolName + " " + versionArgs + "'"));
        Process toolProcess = runtime.exec(toolName + " " + versionArgs);
        InputStream in = toolProcess.getInputStream();
        InputStream err = toolProcess.getErrorStream();
        String outText = this.toString(in).trim();
        String errText = this.toString(err).trim();
        Message.verbose((String)("err: " + errText));
        return outText + errText;
    }

    private String toString(InputStream inputStream) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((read = inputStream.read(buffer)) != -1) {
            ((OutputStream)outputStream).write(buffer, 0, read);
        }
        ((OutputStream)outputStream).close();
        inputStream.close();
        return ((Object)outputStream).toString();
    }
}

