/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.ant.taskdefs;

import com.nokia.helium.core.ant.VariableIFImpl;
import com.nokia.helium.core.ant.types.Variable;
import java.util.Collection;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GetValueFromVariableSet
extends Task {
    private String name;
    private String property;
    private boolean failOnError = true;
    private Vector<VariableIFImpl> variableIntefaces = new Vector();

    public void setName(String name) {
        this.name = name;
    }

    public void setFailOnError(boolean failStatus) {
        this.failOnError = failStatus;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public VariableIFImpl createVariableIFImpl() {
        VariableIFImpl var = new VariableIFImpl();
        this.add(var);
        return var;
    }

    public void add(VariableIFImpl vs) {
        this.variableIntefaces.add(vs);
    }

    public VariableIFImpl getVariableInterface() {
        if (this.variableIntefaces.isEmpty()) {
            throw new BuildException("variable interface cannot be null");
        }
        if (this.variableIntefaces.size() > 1) {
            throw new BuildException("maximum one variable interface can be set");
        }
        return this.variableIntefaces.elementAt(0);
    }

    public void execute() {
        if (this.name == null) {
            throw new BuildException("'name' attribute has not been defined.");
        }
        if (this.property == null) {
            throw new BuildException("'property' attribute has not been defined.");
        }
        VariableIFImpl varInterface = this.getVariableInterface();
        Collection<Variable> variables = varInterface.getVariables();
        for (Variable var : variables) {
            if (!var.getName().equals(this.name)) continue;
            this.getProject().setProperty(this.property, var.getValue());
            return;
        }
        if (this.failOnError) {
            throw new BuildException("Could not find '" + this.name + "' variable.");
        }
    }
}

