/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds;

import com.nokia.helium.core.PropertiesSource;
import com.nokia.helium.core.TemplateInputSource;
import com.nokia.helium.core.TemplateProcessor;
import com.nokia.helium.core.ant.types.HlmPostDefImpl;
import com.nokia.helium.diamonds.DiamondsClient;
import com.nokia.helium.diamonds.DiamondsConfig;
import com.nokia.helium.diamonds.DiamondsException;
import com.nokia.helium.diamonds.DiamondsListenerImpl;
import com.nokia.helium.diamonds.DiamondsProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;

public class DiamondsPostBuildStatusUpdate
extends HlmPostDefImpl {
    private Logger log;
    private String buildStatus = "succeeded";
    private TemplateProcessor templateProcessor;
    private String outputFile;
    private String templateFile;
    private List<TemplateInputSource> sourceList = new ArrayList<TemplateInputSource>();

    public DiamondsPostBuildStatusUpdate() {
        this.log = Logger.getLogger(DiamondsPostBuildStatusUpdate.class);
    }

    public void execute(Project prj, String module, String[] targetNames) {
        this.templateProcessor = new TemplateProcessor();
        Properties tempProperties = new Properties();
        DiamondsProperties diamondsProperties = DiamondsConfig.getDiamondsProperties();
        if (DiamondsListenerImpl.isInitialized()) {
            DiamondsClient diamondsClient = new DiamondsClient(this.getProject().getProperty(diamondsProperties.getProperty("host")), this.getProject().getProperty(diamondsProperties.getProperty("port")), this.getProject().getProperty(diamondsProperties.getProperty("path")), this.getProject().getProperty(diamondsProperties.getProperty("mail")));
            tempProperties.put("build.status", this.buildStatus);
            this.sourceList.add((TemplateInputSource)new PropertiesSource("ant", (Map)this.getProject().getProperties()));
            this.sourceList.add((TemplateInputSource)new PropertiesSource("diamonds", tempProperties));
            this.outputFile = DiamondsConfig.getOutputDir() + File.separator + "diamonds-status.xml";
            this.templateFile = "diamonds_status.xml.ftl";
            this.templateProcessor.convertTemplate(DiamondsConfig.getTemplateDir(), this.templateFile, this.outputFile, this.sourceList);
            this.log.debug((Object)("[DiamondsPostBuildStatusUpdate] => sending data to diamonds ..." + this.outputFile));
            diamondsClient.sendData(this.outputFile, DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
            try {
                DiamondsListenerImpl.mergeToFullResults(new File(this.outputFile));
            }
            catch (DiamondsException de) {
                this.log.error((Object)("Not able to merge into full results XML file " + de.getMessage()), (Throwable)de);
            }
        }
    }
}

